/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.admin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import net.fortuna.ical4j.model.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.CalendarAccountNotFoundException;
import org.jasig.schedassist.ICalendarAccountDao;
import org.jasig.schedassist.ICalendarDataDao;
import org.jasig.schedassist.SchedulingAssistantService;
import org.jasig.schedassist.impl.owner.OwnerDao;
import org.jasig.schedassist.impl.visitor.NotAVisitorException;
import org.jasig.schedassist.impl.visitor.VisitorDao;
import org.jasig.schedassist.model.AvailableBlock;
import org.jasig.schedassist.model.CommonDateOperations;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.IScheduleVisitor;
import org.jasig.schedassist.model.Preferences;
import org.jasig.schedassist.model.VisibleSchedule;
import org.jasig.schedassist.model.VisibleScheduleRequestConstraints;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJacksonJsonView;

@Controller
public class VisibleScheduleDebugController {
    private Log LOG = LogFactory.getLog(this.getClass());
    private SchedulingAssistantService schedulingAssistantService;
    private ICalendarAccountDao calendarAccountDao;
    private OwnerDao ownerDao;
    private VisitorDao visitorDao;
    private ICalendarDataDao calendarDataDao;

    @Autowired
    public void setSchedulingAssistantService(SchedulingAssistantService schedulingAssistantService) {
        this.schedulingAssistantService = schedulingAssistantService;
    }

    @Autowired
    public void setCalendarAccountDao(ICalendarAccountDao calendarAccountDao) {
        this.calendarAccountDao = calendarAccountDao;
    }

    @Autowired
    public void setOwnerDao(OwnerDao ownerDao) {
        this.ownerDao = ownerDao;
    }

    @Autowired
    public void setVisitorDao(VisitorDao visitorDao) {
        this.visitorDao = visitorDao;
    }

    @Autowired
    public void setCalendarDataDao(ICalendarDataDao calendarDataDao) {
        this.calendarDataDao = calendarDataDao;
    }

    @RequestMapping(value={"/admin/schedule-debug/{ownerIdentifier}/view.html"}, method={RequestMethod.GET})
    public String displaySchedule(@PathVariable(value="ownerIdentifier") long ownerIdentifier, @RequestParam(value="highContrast", required=false, defaultValue="false") boolean highContrast, @RequestParam(value="weekStart", required=false, defaultValue="0") int weekStart, @RequestParam(value="visitorUsername", required=true) String visitorUsername, ModelMap model) throws NotAVisitorException, CalendarAccountNotFoundException {
        VisibleSchedule schedule;
        ICalendarAccount visitorAccount = this.calendarAccountDao.getCalendarAccount(visitorUsername);
        if (visitorAccount == null) {
            throw new NotAVisitorException(visitorUsername + " not found");
        }
        IScheduleVisitor visitor = this.visitorDao.toVisitor(visitorAccount);
        model.addAttribute("visitor", (Object)visitor);
        IScheduleOwner selectedOwner = this.ownerDao.locateOwnerByAvailableId(ownerIdentifier);
        if (selectedOwner == null) {
            throw new CalendarAccountNotFoundException("no owner found for id " + ownerIdentifier);
        }
        VisibleScheduleRequestConstraints requestConstraints = VisibleScheduleRequestConstraints.newInstance((IScheduleOwner)selectedOwner, (int)weekStart);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("displaySchedule request, visitor: " + visitor + "; weekStart: " + weekStart + "requestConstraints " + requestConstraints));
        }
        Calendar ownerCalendar = this.calendarDataDao.getCalendar(selectedOwner.getCalendarAccount(), requestConstraints.getTargetStartDate(), requestConstraints.getTargetEndDate());
        model.addAttribute("ownerCalendarData", (Object)ownerCalendar.toString());
        model.addAttribute("noteboard", (Object)selectedOwner.getPreference(Preferences.NOTEBOARD));
        model.addAttribute("owner", (Object)selectedOwner);
        model.addAttribute("highContrast", (Object)highContrast);
        if (selectedOwner.hasMeetingLimit()) {
            schedule = this.schedulingAssistantService.getVisibleSchedule(visitor, selectedOwner);
            if (selectedOwner.isExceedingMeetingLimit(schedule.getAttendingCount())) {
                List attendingList = schedule.getAttendingList();
                model.addAttribute("attendingList", (Object)attendingList);
                return "admin/debug-already-attending";
            }
            schedule = schedule.subset(requestConstraints.getTargetStartDate(), requestConstraints.getTargetEndDate());
        } else {
            schedule = this.schedulingAssistantService.getVisibleSchedule(visitor, selectedOwner, requestConstraints.getTargetStartDate(), requestConstraints.getTargetEndDate());
        }
        model.addAttribute("visibleSchedule", (Object)schedule);
        model.addAttribute("scheduleStart", (Object)schedule.getScheduleStart());
        model.addAttribute("prevWeekStart", (Object)requestConstraints.getPrevWeekIndex());
        model.addAttribute("nextWeekStart", (Object)requestConstraints.getNextWeekIndex());
        model.addAttribute("weekStart", (Object)requestConstraints.getConstrainedWeekStart());
        model.addAttribute("ownerVisitorSamePerson", (Object)selectedOwner.isSamePerson(visitor));
        return "admin/debug-visible-schedule";
    }

    @RequestMapping(value={"/admin/schedule-debug/{ownerIdentifier}/visitor-conflicts.json"}, method={RequestMethod.GET})
    public View visitorConflicts(@PathVariable(value="ownerIdentifier") long ownerIdentifier, @RequestParam(value="weekStart", required=false, defaultValue="1") int weekStart, @RequestParam(value="visitorUsername", required=true) String visitorUsername, ModelMap model) throws NotAVisitorException, CalendarAccountNotFoundException {
        ICalendarAccount visitorAccount = this.calendarAccountDao.getCalendarAccount(visitorUsername);
        if (visitorAccount == null) {
            throw new NotAVisitorException(visitorUsername + " not found");
        }
        IScheduleVisitor visitor = this.visitorDao.toVisitor(visitorAccount);
        IScheduleOwner owner = this.ownerDao.locateOwnerByAvailableId(ownerIdentifier);
        if (owner == null) {
            throw new CalendarAccountNotFoundException("no owner found for id " + ownerIdentifier);
        }
        VisibleScheduleRequestConstraints requestConstraints = VisibleScheduleRequestConstraints.newInstance((IScheduleOwner)owner, (int)weekStart);
        List visitorConflicts = this.schedulingAssistantService.calculateVisitorConflicts(visitor, owner, requestConstraints.getTargetStartDate(), requestConstraints.getTargetEndDate());
        ArrayList<String> conflictBlocks = new ArrayList<String>();
        SimpleDateFormat df = CommonDateOperations.getDateTimeFormat();
        for (AvailableBlock b : visitorConflicts) {
            conflictBlocks.add(df.format(b.getStartTime()));
        }
        model.addAttribute("conflicts", conflictBlocks);
        Calendar visitorCalendar = this.calendarDataDao.getCalendar(visitorAccount, requestConstraints.getTargetStartDate(), requestConstraints.getTargetEndDate());
        model.addAttribute("visitorCalendarData", (Object)visitorCalendar.toString());
        return new MappingJacksonJsonView();
    }
}

