/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.owner.relationships;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jasig.schedassist.ICalendarAccountDao;
import org.jasig.schedassist.MutableRelationshipDao;
import org.jasig.schedassist.impl.owner.NotRegisteredException;
import org.jasig.schedassist.impl.visitor.VisitorDao;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.web.owner.relationships.CSVFileImportFormController;
import org.jasig.schedassist.web.owner.relationships.CSVFileImportResult;
import org.jasig.schedassist.web.security.CalendarAccountUserDetails;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/owner/create-relationships-import.html", "/delegate/create-relationships-import.html"})
public class CSVFileImportFormController
implements DisposableBean {
    public static final String IMPORT_FUTURE_NAME = CSVFileImportFormController.class.getPackage().getName() + ".SharingFileImportFormController.IMPORT_FUTURE";
    private String statusViewName = "owner-relationships/csv-import-status";
    private String formViewName = "owner-relationships/csv-import-form";
    private ExecutorService executorService;
    private MutableRelationshipDao mutableRelationshipDao;
    private VisitorDao visitorDao;
    private ICalendarAccountDao calendarAccountDao;

    @Autowired
    public void setExecutorService(@Qualifier(value="fileImportExecutorService") ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Autowired
    public void setMutableRelationshipDao(MutableRelationshipDao mutableRelationshipDao) {
        this.mutableRelationshipDao = mutableRelationshipDao;
    }

    @Autowired
    public void setVisitorDao(VisitorDao visitorDao) {
        this.visitorDao = visitorDao;
    }

    @Autowired
    public void setCalendarAccountDao(ICalendarAccountDao calendarAccountDao) {
        this.calendarAccountDao = calendarAccountDao;
    }

    public void destroy() throws Exception {
        this.executorService.shutdownNow();
    }

    @RequestMapping(method={RequestMethod.POST})
    protected String uploadFile(ModelMap model, @RequestParam(value="file") MultipartFile file, HttpServletRequest request) throws NotRegisteredException {
        CalendarAccountUserDetails currentUser = (CalendarAccountUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        IScheduleOwner owner = currentUser.getScheduleOwner();
        FileImportCallable callable = new FileImportCallable(file, this.calendarAccountDao, this.visitorDao, owner, this.mutableRelationshipDao);
        Future f = this.executorService.submit(callable);
        request.getSession(true).setAttribute(IMPORT_FUTURE_NAME, f);
        model.addAttribute("submitted", (Object)true);
        return this.statusViewName;
    }

    @RequestMapping(method={RequestMethod.GET})
    protected String showForm(ModelMap model, HttpServletRequest request, @RequestParam(value="dismiss", required=false, defaultValue="false") boolean dismiss) throws InterruptedException, ExecutionException, NotRegisteredException {
        HttpSession currentSession = request.getSession();
        if (null != currentSession) {
            Future f;
            if (dismiss) {
                currentSession.setAttribute(IMPORT_FUTURE_NAME, null);
            }
            if (null != (f = (Future)currentSession.getAttribute(IMPORT_FUTURE_NAME))) {
                if (f.isDone()) {
                    CSVFileImportResult importResult = (CSVFileImportResult)f.get();
                    model.addAttribute("processing", (Object)false);
                    model.addAttribute("importResult", (Object)importResult);
                    currentSession.setAttribute(IMPORT_FUTURE_NAME, null);
                    return this.statusViewName;
                }
                model.addAttribute("processing", (Object)true);
                return this.statusViewName;
            }
        }
        return this.formViewName;
    }
}

