/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.owner.relationships;

import org.jasig.schedassist.CalendarAccountNotFoundException;
import org.jasig.schedassist.ICalendarAccountDao;
import org.jasig.schedassist.MutableRelationshipDao;
import org.jasig.schedassist.impl.owner.NotRegisteredException;
import org.jasig.schedassist.impl.visitor.NotAVisitorException;
import org.jasig.schedassist.impl.visitor.VisitorDao;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.IScheduleVisitor;
import org.jasig.schedassist.web.owner.relationships.ModifyAdhocRelationshipFormBackingObject;
import org.jasig.schedassist.web.security.CalendarAccountUserDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/owner/destroy-adhoc-relationship.html", "/delegate/destroy-adhoc-relationship.html"})
public class DestroyAdhocRelationshipController {
    private ICalendarAccountDao calendarAccountDao;
    private VisitorDao visitorDao;
    private MutableRelationshipDao mutableRelationshipDao;

    @Autowired
    public void setCalendarAccountDao(ICalendarAccountDao calendarAccountDao) {
        this.calendarAccountDao = calendarAccountDao;
    }

    @Autowired
    public void setVisitorDao(VisitorDao visitorDao) {
        this.visitorDao = visitorDao;
    }

    @Autowired
    public void setMutableRelationshipDao(@Qualifier(value="adhoc") MutableRelationshipDao mutableRelationshipDao) {
        this.mutableRelationshipDao = mutableRelationshipDao;
    }

    @RequestMapping(method={RequestMethod.GET})
    protected String setupForm(ModelMap model) {
        model.addAttribute("command", (Object)new ModifyAdhocRelationshipFormBackingObject());
        return "owner-relationships/destroy-adhoc-relationship-form";
    }

    @RequestMapping(method={RequestMethod.POST})
    protected String destroyAdhocRelationship(@ModelAttribute(value="command") ModifyAdhocRelationshipFormBackingObject fbo, ModelMap model) throws CalendarAccountNotFoundException, NotAVisitorException, NotRegisteredException {
        CalendarAccountUserDetails currentUser = (CalendarAccountUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        IScheduleOwner owner = currentUser.getScheduleOwner();
        ICalendarAccount visitorUser = this.calendarAccountDao.getCalendarAccount(fbo.getVisitorUsername());
        if (null == visitorUser) {
            throw new CalendarAccountNotFoundException(fbo.getVisitorUsername() + " does not exist or is not eligible for WiscCal");
        }
        IScheduleVisitor visitor = this.visitorDao.toVisitor(visitorUser);
        this.mutableRelationshipDao.destroyRelationship(owner, visitor);
        model.addAttribute("visitor", (Object)visitor);
        model.addAttribute("relationship", (Object)fbo.getRelationship());
        return "owner-relationships/destroy-adhoc-relationship-success";
    }
}

