/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.owner.schedule;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import java.util.SortedSet;
import javax.validation.Valid;
import org.jasig.schedassist.impl.owner.AvailableScheduleDao;
import org.jasig.schedassist.impl.owner.NotRegisteredException;
import org.jasig.schedassist.model.AvailableBlockBuilder;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.InputFormatException;
import org.jasig.schedassist.model.Preferences;
import org.jasig.schedassist.web.owner.schedule.BlockBuilderFormBackingObject;
import org.jasig.schedassist.web.owner.schedule.BlockBuilderFormBackingObjectValidator;
import org.jasig.schedassist.web.security.CalendarAccountUserDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/owner/builder.html", "/delegate/builder.html"})
public class BlockBuilderFormController {
    private AvailableScheduleDao availableScheduleDao;

    @Autowired
    public void setAvailableScheduleDao(AvailableScheduleDao availableScheduleDao) {
        this.availableScheduleDao = availableScheduleDao;
    }

    @InitBinder
    protected void initBinder(WebDataBinder binder) {
        binder.setValidator((Validator)new BlockBuilderFormBackingObjectValidator());
    }

    @RequestMapping(method={RequestMethod.GET})
    protected String setupForm(ModelMap model) throws NotRegisteredException {
        CalendarAccountUserDetails currentUser = (CalendarAccountUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        IScheduleOwner owner = currentUser.getScheduleOwner();
        int defaultVisitorLimit = Integer.parseInt(owner.getPreference(Preferences.DEFAULT_VISITOR_LIMIT));
        BlockBuilderFormBackingObject fbo = new BlockBuilderFormBackingObject();
        fbo.setVisitorsPerAppointment(defaultVisitorLimit);
        fbo.setMeetingLocation(owner.getPreferredLocation());
        model.addAttribute("command", (Object)fbo);
        return "owner-schedule/builder-form";
    }

    @RequestMapping(method={RequestMethod.POST})
    protected String updateSchedule(@Valid @ModelAttribute(value="command") BlockBuilderFormBackingObject fbo, BindingResult bindingResult) throws InputFormatException, ParseException, NotRegisteredException {
        CalendarAccountUserDetails currentUser = (CalendarAccountUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        IScheduleOwner owner = currentUser.getScheduleOwner();
        if (bindingResult.hasErrors()) {
            return "owner-schedule/builder-form";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
        String meetingLocation = owner.getPreferredLocation();
        if (meetingLocation.equals(fbo.getMeetingLocation())) {
            meetingLocation = null;
        }
        SortedSet blocks = AvailableBlockBuilder.createBlocks((String)fbo.getStartTimePhrase(), (String)fbo.getEndTimePhrase(), (String)fbo.getDaysOfWeekPhrase(), (Date)dateFormat.parse(fbo.getStartDatePhrase()), (Date)dateFormat.parse(fbo.getEndDatePhrase()), (int)fbo.getVisitorsPerAppointment(), (String)fbo.getMeetingLocation());
        this.availableScheduleDao.addToSchedule(owner, (Set)blocks);
        return "redirect:schedule.html";
    }
}

