/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.owner.schedule;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.impl.AvailableScheduleReflectionService;
import org.jasig.schedassist.impl.owner.AvailableScheduleDao;
import org.jasig.schedassist.impl.owner.NotRegisteredException;
import org.jasig.schedassist.model.AvailableSchedule;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.web.owner.schedule.ClearAvailableScheduleFormBackingObject;
import org.jasig.schedassist.web.security.CalendarAccountUserDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@RequestMapping(value={"/owner/clear-entire-schedule.html", "/delegate/clear-entire-schedule.html"})
public class ClearEntireAvailableScheduleFormController {
    private Log LOG = LogFactory.getLog(this.getClass());
    private AvailableScheduleDao availableScheduleDao;
    private AvailableScheduleReflectionService reflectionService;

    @Autowired
    public void setAvailableScheduleDao(AvailableScheduleDao availableScheduleDao) {
        this.availableScheduleDao = availableScheduleDao;
    }

    @Autowired
    public void setReflectionService(AvailableScheduleReflectionService reflectionService) {
        this.reflectionService = reflectionService;
    }

    @RequestMapping(method={RequestMethod.GET})
    protected String setupForm(ModelMap model) {
        ClearAvailableScheduleFormBackingObject fbo = new ClearAvailableScheduleFormBackingObject();
        model.addAttribute("command", (Object)fbo);
        return "owner-schedule/clear-schedule-form";
    }

    @RequestMapping(method={RequestMethod.POST})
    protected ModelAndView clearSchedule(@ModelAttribute ClearAvailableScheduleFormBackingObject fbo) throws NotRegisteredException {
        CalendarAccountUserDetails currentUser = (CalendarAccountUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        IScheduleOwner owner = currentUser.getScheduleOwner();
        if (fbo.isConfirmedCancelAll()) {
            AvailableSchedule schedule = this.availableScheduleDao.retrieve(owner);
            if (!schedule.isEmpty()) {
                this.availableScheduleDao.clearAllBlocks(owner);
                this.reflectionService.purgeReflections(owner, schedule.getScheduleStartTime(), schedule.getScheduleEndTime());
            }
            return new ModelAndView("owner-schedule/clear-schedule-success");
        }
        this.LOG.info((Object)("owner (" + owner + ") did not confirm request to clear schedule, cancelling"));
        return new ModelAndView((View)new RedirectView("schedule.html", true));
    }
}

