/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.owner.schedule;

import java.util.HashMap;
import org.jasig.schedassist.SchedulingAssistantService;
import org.jasig.schedassist.impl.owner.NotRegisteredException;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.Preferences;
import org.jasig.schedassist.model.VisibleSchedule;
import org.jasig.schedassist.model.VisibleScheduleRequestConstraints;
import org.jasig.schedassist.web.security.CalendarAccountUserDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/owner/preview.html", "/delegate/preview.html"})
public class PreviewVisibleScheduleController {
    private SchedulingAssistantService schedulingAssistantService;

    @Autowired
    public void setSchedulingAssistantService(SchedulingAssistantService schedulingAssistantService) {
        this.schedulingAssistantService = schedulingAssistantService;
    }

    @RequestMapping(method={RequestMethod.GET})
    protected ModelAndView previewVisibleSchedule(@RequestParam(value="highContrast", required=false, defaultValue="false") boolean highContrast, @RequestParam(value="weekStart", required=false, defaultValue="0") int weekStart) throws NotRegisteredException {
        CalendarAccountUserDetails currentUser = (CalendarAccountUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        IScheduleOwner owner = currentUser.getScheduleOwner();
        VisibleScheduleRequestConstraints requestConstraints = VisibleScheduleRequestConstraints.newInstance((IScheduleOwner)owner, (int)weekStart);
        VisibleSchedule schedule = this.schedulingAssistantService.getVisibleSchedule(null, owner, requestConstraints.getTargetStartDate(), requestConstraints.getTargetEndDate());
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("prevWeekStart", requestConstraints.getPrevWeekIndex());
        model.put("nextWeekStart", requestConstraints.getNextWeekIndex());
        model.put("scheduleStart", schedule.getScheduleStart());
        model.put("visibleSchedule", schedule);
        String noteboard = owner.getPreference(Preferences.NOTEBOARD);
        String[] noteboardSentences = noteboard.split("\n");
        model.put("noteboardSentences", noteboardSentences);
        model.put("owner", owner);
        model.put("highContrast", highContrast);
        model.put("weekStart", weekStart);
        return new ModelAndView("owner-schedule/preview-visible-schedule", model);
    }
}

