/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.register;

import java.util.Date;
import javax.validation.Valid;
import org.jasig.schedassist.impl.AvailableScheduleReflectionService;
import org.jasig.schedassist.impl.owner.AvailableScheduleDao;
import org.jasig.schedassist.impl.owner.NotRegisteredException;
import org.jasig.schedassist.impl.owner.OwnerDao;
import org.jasig.schedassist.model.AvailableSchedule;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.web.register.RemoveAccountFormBackingObject;
import org.jasig.schedassist.web.register.RemoveAccountFormBackingObjectValidator;
import org.jasig.schedassist.web.security.CalendarAccountUserDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/owner/removeAccount.html", "/delegate/removeAccount.html"})
public class RemoveAccountFormController {
    private OwnerDao ownerDao;
    private AvailableScheduleDao availableScheduleDao;
    private AvailableScheduleReflectionService availableScheduleReflectionService;

    @Autowired
    public void setOwnerDao(OwnerDao ownerDao) {
        this.ownerDao = ownerDao;
    }

    @Autowired
    public void setAvailableScheduleDao(AvailableScheduleDao availableScheduleDao) {
        this.availableScheduleDao = availableScheduleDao;
    }

    @Autowired
    public void setAvailableScheduleReflectionService(AvailableScheduleReflectionService availableScheduleReflectionService) {
        this.availableScheduleReflectionService = availableScheduleReflectionService;
    }

    @InitBinder(value={"command"})
    protected void initBinder(WebDataBinder binder) {
        binder.setValidator((Validator)new RemoveAccountFormBackingObjectValidator());
    }

    @RequestMapping(method={RequestMethod.GET})
    protected String displayForm(ModelMap model) {
        model.addAttribute("command", (Object)new RemoveAccountFormBackingObject());
        return "remove-account-form";
    }

    @RequestMapping(method={RequestMethod.POST})
    protected String removeAccount(@Valid @ModelAttribute RemoveAccountFormBackingObject fbo, BindingResult result) throws NotRegisteredException {
        CalendarAccountUserDetails currentUser = (CalendarAccountUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        IScheduleOwner owner = currentUser.getScheduleOwner();
        if (null == owner) {
            throw new NotRegisteredException("action requires registration");
        }
        if (result.hasErrors()) {
            return "remove-account-form";
        }
        if (fbo.isConfirmed()) {
            if (owner.isReflectSchedule()) {
                AvailableSchedule schedule = this.availableScheduleDao.retrieve(owner);
                this.availableScheduleReflectionService.purgeReflections(owner, new Date(), schedule.getScheduleEndTime());
            }
            this.ownerDao.removeAccount(owner);
            SecurityContextHolder.getContext().setAuthentication(null);
            return "redirect:/accountRemoved.html";
        }
        return "redirect:schedule.html";
    }
}

