/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.security;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.ICalendarAccountDao;
import org.jasig.schedassist.impl.owner.OwnerDao;
import org.jasig.schedassist.impl.visitor.NotAVisitorException;
import org.jasig.schedassist.impl.visitor.VisitorDao;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.IScheduleVisitor;
import org.jasig.schedassist.web.security.CalendarAccountUserDetailsImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="userDetailsService")
public class CalendarAccountUserDetailsServiceImpl
implements UserDetailsService {
    private static final String NONE_PROVIDED = "NONE_PROVIDED";
    private ICalendarAccountDao calendarAccountDao;
    private VisitorDao visitorDao;
    private OwnerDao ownerDao;
    private List<String> administrators = new ArrayList();
    protected final Log LOG = LogFactory.getLog(this.getClass());

    @Autowired
    public void setCalendarAccountDao(ICalendarAccountDao calendarAccountDao) {
        this.calendarAccountDao = calendarAccountDao;
    }

    @Autowired
    public void setVisitorDao(VisitorDao visitorDao) {
        this.visitorDao = visitorDao;
    }

    @Autowired
    public void setOwnerDao(OwnerDao ownerDao) {
        this.ownerDao = ownerDao;
    }

    public void setAdministratorListProperty(String propertyValue) {
        Object[] admins = StringUtils.commaDelimitedListToStringArray((String)propertyValue);
        this.administrators = Arrays.asList((Object[])admins);
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        if (NONE_PROVIDED.equals(username)) {
            this.LOG.debug((Object)"caught NONE_PROVIDED being passed into loadUserByUsername");
            throw new UsernameNotFoundException(NONE_PROVIDED);
        }
        ICalendarAccount calendarAccount = this.calendarAccountDao.getCalendarAccount(username);
        if (null == calendarAccount) {
            throw new UsernameNotFoundException("no calendar account found for " + username);
        }
        CalendarAccountUserDetailsImpl result = new CalendarAccountUserDetailsImpl(calendarAccount);
        try {
            IScheduleVisitor scheduleVisitor = this.visitorDao.toVisitor(calendarAccount);
            result.setScheduleVisitor(scheduleVisitor);
        }
        catch (NotAVisitorException e) {
            this.LOG.debug((Object)(username + " is not a visitor"));
        }
        IScheduleOwner scheduleOwner = this.ownerDao.locateOwner(calendarAccount);
        result.setScheduleOwner(scheduleOwner);
        if (this.administrators.contains(username)) {
            result.setAdministrator(true);
        }
        return result;
    }
}

