/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.security;

import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.ppolicy.PasswordPolicyException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CustomLDAPAuthenticationProvider
extends DaoAuthenticationProvider {
    private LdapAuthenticator authenticator;

    public LdapAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(LdapAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        String username = authentication.getName();
        String password = (String)authentication.getCredentials();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Processing authentication request for user: " + username));
        }
        if (!StringUtils.hasLength((String)username)) {
            throw new BadCredentialsException(this.messages.getMessage("LdapAuthenticationProvider.emptyUsername", "Empty Username"));
        }
        Assert.notNull((Object)password, (String)"Null password was supplied in authentication token");
        try {
            DirContextOperations userData = this.getAuthenticator().authenticate((Authentication)authentication);
            if (userData == null) {
                throw new BadCredentialsException(this.messages.getMessage("LdapAuthenticationProvider.badCredentials", "Bad credentials"));
            }
        }
        catch (PasswordPolicyException ppe) {
            throw new LockedException(this.messages.getMessage(ppe.getStatus().getErrorCode(), ppe.getStatus().getDefaultMessage()));
        }
        catch (UsernameNotFoundException notFound) {
            if (this.hideUserNotFoundExceptions) {
                throw new BadCredentialsException(this.messages.getMessage("LdapAuthenticationProvider.badCredentials", "Bad credentials"));
            }
            throw notFound;
        }
    }
}

