/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.visitor;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import net.fortuna.ical4j.model.component.VEvent;
import org.apache.commons.lang.StringUtils;
import org.jasig.schedassist.NoAppointmentExistsException;
import org.jasig.schedassist.RelationshipDao;
import org.jasig.schedassist.SchedulingAssistantService;
import org.jasig.schedassist.SchedulingException;
import org.jasig.schedassist.impl.owner.AvailableScheduleDao;
import org.jasig.schedassist.impl.owner.OwnerDao;
import org.jasig.schedassist.impl.owner.PublicProfileDao;
import org.jasig.schedassist.impl.visitor.NotAVisitorException;
import org.jasig.schedassist.model.AvailableBlock;
import org.jasig.schedassist.model.AvailableBlockBuilder;
import org.jasig.schedassist.model.CommonDateOperations;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.IScheduleVisitor;
import org.jasig.schedassist.model.InputFormatException;
import org.jasig.schedassist.model.PublicProfile;
import org.jasig.schedassist.model.Relationship;
import org.jasig.schedassist.web.security.CalendarAccountUserDetailsImpl;
import org.jasig.schedassist.web.visitor.CancelAppointmentFormBackingObject;
import org.jasig.schedassist.web.visitor.CancelAppointmentFormBackingObjectValidator;
import org.jasig.schedassist.web.visitor.OwnerNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;

@Controller
@RequestMapping(value={"/schedule/{ownerIdentifier}/cancel.html"})
@SessionAttributes(value={"command"})
public class CancelAppointmentFormController {
    private SchedulingAssistantService schedulingAssistantService;
    private RelationshipDao relationshipDao;
    private AvailableScheduleDao availableScheduleDao;
    private OwnerDao ownerDao;
    private PublicProfileDao publicProfileDao;

    @Autowired
    public void setAvailableService(SchedulingAssistantService schedulingAssistantService) {
        this.schedulingAssistantService = schedulingAssistantService;
    }

    @Autowired
    public void setAvailableScheduleDao(AvailableScheduleDao availableScheduleDao) {
        this.availableScheduleDao = availableScheduleDao;
    }

    @Autowired
    public void setRelationshipDao(@Qualifier(value="composite") RelationshipDao relationshipDao) {
        this.relationshipDao = relationshipDao;
    }

    @Autowired
    public void setOwnerDao(OwnerDao ownerDao) {
        this.ownerDao = ownerDao;
    }

    @Autowired
    public void setPublicProfileDao(PublicProfileDao publicProfileDao) {
        this.publicProfileDao = publicProfileDao;
    }

    @InitBinder(value={"command"})
    protected void initBinder(WebDataBinder binder) {
        binder.setValidator((Validator)new CancelAppointmentFormBackingObjectValidator());
    }

    @RequestMapping(method={RequestMethod.GET})
    protected String setupForm(ModelMap model, @RequestParam(value="startTime", required=true) String startTimePhrase, @RequestParam(value="endTime", required=true) String endTimePhrase, @PathVariable(value="ownerIdentifier") String ownerIdentifier) throws ParseException, NotAVisitorException, OwnerNotFoundException, InputFormatException, SchedulingException {
        SimpleDateFormat dateFormat = CommonDateOperations.getDateTimeFormat();
        Date time = dateFormat.parse(startTimePhrase);
        model.put((Object)"startTimePhrase", (Object)startTimePhrase);
        model.put((Object)"startTime", (Object)time);
        CalendarAccountUserDetailsImpl currentUser = (CalendarAccountUserDetailsImpl)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        IScheduleVisitor visitor = currentUser.getScheduleVisitor();
        IScheduleOwner selectedOwner = null;
        if (StringUtils.isNumeric((String)ownerIdentifier)) {
            Long ownerId = Long.parseLong(ownerIdentifier);
            selectedOwner = this.findOwnerForVisitor(visitor, ownerId.longValue());
        } else {
            PublicProfile profile = this.publicProfileDao.locatePublicProfileByKey(ownerIdentifier);
            if (null != profile) {
                selectedOwner = this.ownerDao.locateOwnerByAvailableId(profile.getOwnerId());
            }
        }
        if (null == selectedOwner) {
            throw new OwnerNotFoundException("no owner found for " + ownerIdentifier);
        }
        model.put((Object)"owner", (Object)selectedOwner);
        Date startTime = CommonDateOperations.parseDateTimePhrase((String)startTimePhrase);
        Date endTime = CommonDateOperations.parseDateTimePhrase((String)endTimePhrase);
        AvailableBlock targetBlock = this.availableScheduleDao.retrieveTargetBlock(selectedOwner, startTime);
        if (null == targetBlock) {
            throw new SchedulingException("requested time is not available in schedule");
        }
        if (!targetBlock.getEndTime().equals(endTime)) {
            targetBlock = this.availableScheduleDao.retrieveTargetDoubleLengthBlock(selectedOwner, startTime);
        }
        if (null != targetBlock && targetBlock.getEndTime().equals(endTime)) {
            VEvent existingEvent = this.schedulingAssistantService.getExistingAppointment(targetBlock, selectedOwner);
            if (null == existingEvent) {
                throw new NoAppointmentExistsException("no available appointment found in " + targetBlock);
            }
            if (null == existingEvent.getProperty("X-UW-AVAILABLE-VERSION")) {
                targetBlock = AvailableBlockBuilder.createBlock((Date)targetBlock.getStartTime(), (Date)targetBlock.getEndTime(), (int)1);
            }
            CancelAppointmentFormBackingObject fbo = new CancelAppointmentFormBackingObject(targetBlock);
            model.put((Object)"command", (Object)fbo);
            return "visitor/cancel-appointment-form";
        }
        throw new SchedulingException("requested time is not available in schedule");
    }

    @RequestMapping(method={RequestMethod.POST})
    protected String cancelAppointment(ModelMap model, @PathVariable(value="ownerIdentifier") String ownerIdentifier, @Valid @ModelAttribute(value="command") CancelAppointmentFormBackingObject fbo, BindingResult bindingResult) throws NotAVisitorException, OwnerNotFoundException, SchedulingException {
        CalendarAccountUserDetailsImpl currentUser = (CalendarAccountUserDetailsImpl)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        IScheduleVisitor visitor = currentUser.getScheduleVisitor();
        if (bindingResult.hasErrors()) {
            return "visitor/cancel-appointment-form";
        }
        IScheduleOwner selectedOwner = null;
        if (StringUtils.isNumeric((String)ownerIdentifier)) {
            Long ownerId = Long.parseLong(ownerIdentifier);
            selectedOwner = this.findOwnerForVisitor(visitor, ownerId.longValue());
        } else {
            PublicProfile profile = this.publicProfileDao.locatePublicProfileByKey(ownerIdentifier);
            if (null != profile) {
                selectedOwner = this.ownerDao.locateOwnerByAvailableId(profile.getOwnerId());
            }
        }
        if (null == selectedOwner) {
            throw new OwnerNotFoundException("no owner found for " + ownerIdentifier);
        }
        AvailableBlock block = fbo.getTargetBlock();
        VEvent existingEvent = this.schedulingAssistantService.getExistingAppointment(block, selectedOwner);
        if (null == existingEvent) {
            throw new NoAppointmentExistsException("no available appointment found in " + block);
        }
        this.schedulingAssistantService.cancelAppointment(visitor, selectedOwner, existingEvent, block, fbo.getReason());
        model.addAttribute("owner", (Object)selectedOwner);
        model.addAttribute("event", (Object)existingEvent);
        return "visitor/cancel-appointment-success";
    }

    private IScheduleOwner findOwnerForVisitor(IScheduleVisitor visitor, long ownerId) throws OwnerNotFoundException {
        List relationships = this.relationshipDao.forVisitor(visitor);
        for (Relationship potential : relationships) {
            if (potential.getOwner().getId() != ownerId) continue;
            return potential.getOwner();
        }
        throw new OwnerNotFoundException("owner id " + ownerId + " not found");
    }
}

