/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.admin;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jasig.schedassist.ICalendarAccountDao;
import org.jasig.schedassist.IDelegateCalendarAccountDao;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.IDelegateCalendarAccount;
import org.jasig.schedassist.web.admin.AccountLookupFormBackingObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;

@Controller
@RequestMapping(value={"/admin/account-lookup.html"})
@SessionAttributes(value={"command"})
public class AccountLookupFormController {
    private ICalendarAccountDao calendarAccountDao;
    private IDelegateCalendarAccountDao delegateCalendarAccountDao;

    @Autowired
    public void setCalendarAccountDao(@Qualifier(value="people") ICalendarAccountDao calendarAccountDao) {
        this.calendarAccountDao = calendarAccountDao;
    }

    @Autowired
    public void setDelegateCalendarAccountDao(@Qualifier(value="delegates") IDelegateCalendarAccountDao delegateCalendarAccountDao) {
        this.delegateCalendarAccountDao = delegateCalendarAccountDao;
    }

    @RequestMapping(method={RequestMethod.GET})
    protected String showForm(ModelMap model) {
        AccountLookupFormBackingObject fbo = new AccountLookupFormBackingObject();
        model.addAttribute("command", (Object)fbo);
        return "admin/account-lookup-form";
    }

    @RequestMapping(method={RequestMethod.GET}, params={"type=people"})
    protected String peopleAjaxQuery(@RequestParam(value="q", required=true) String qValue, ModelMap model) {
        model.addAttribute("searchText", (Object)qValue);
        List results = new ArrayList();
        if (qValue.length() > 2) {
            String searchText = StringUtils.replace((String)qValue, (String)" ", (String)"*");
            results = this.calendarAccountDao.searchForCalendarAccounts(searchText);
        }
        model.addAttribute("results", results);
        return "admin/account-results-ac-people";
    }

    @RequestMapping(method={RequestMethod.GET}, params={"type=resources"})
    protected String resourcesAjaxQuery(@RequestParam(value="q", required=true) String qValue, ModelMap model) {
        model.addAttribute("searchText", (Object)qValue);
        List results = new ArrayList();
        if (qValue.length() > 2) {
            String searchText = StringUtils.replace((String)qValue, (String)" ", (String)"*");
            results = this.delegateCalendarAccountDao.searchForDelegates(searchText);
        }
        model.addAttribute("results", results);
        return "admin/account-results-ac-resources";
    }

    @RequestMapping(method={RequestMethod.POST})
    protected String interactiveSearch(@ModelAttribute(value="command") AccountLookupFormBackingObject fbo, ModelMap model) {
        IDelegateCalendarAccount delegate;
        ICalendarAccount account;
        ArrayList<Object> results = new ArrayList<Object>();
        if (StringUtils.isNotBlank((String)fbo.getCtcalxitemid()) && null != (account = this.calendarAccountDao.getCalendarAccountFromUniqueId(fbo.getCtcalxitemid()))) {
            results.add(account);
        }
        if (StringUtils.isNotBlank((String)fbo.getUsername()) && null != (account = this.calendarAccountDao.getCalendarAccount(fbo.getUsername()))) {
            results.add(account);
        }
        if (StringUtils.isNotBlank((String)fbo.getResourceName()) && null != (delegate = this.delegateCalendarAccountDao.getDelegate(fbo.getResourceName()))) {
            results.add(delegate);
        }
        if (StringUtils.isNotBlank((String)fbo.getSearchText()) && fbo.getSearchText().length() > 2) {
            String searchText = StringUtils.replace((String)fbo.getSearchText(), (String)" ", (String)"*");
            results.addAll(this.calendarAccountDao.searchForCalendarAccounts(searchText));
            results.addAll(this.delegateCalendarAccountDao.searchForDelegates(searchText));
        }
        if (results.size() == 1) {
            account = (ICalendarAccount)results.get(0);
            return "redirect:/admin/account-details.html?id=" + account.getCalendarUniqueId();
        }
        model.addAttribute("results", results);
        return "admin/account-results";
    }
}

