/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.owner.schedule;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.SortedSet;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.impl.owner.AvailableScheduleDao;
import org.jasig.schedassist.impl.owner.NotRegisteredException;
import org.jasig.schedassist.model.AvailableBlockBuilder;
import org.jasig.schedassist.model.AvailableSchedule;
import org.jasig.schedassist.model.CommonDateOperations;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.web.security.CalendarAccountUserDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/owner/schedule-noscript.html", "/delegate/schedule-noscript.html"})
public class AlternateScheduleViewController {
    private Log LOG = LogFactory.getLog(this.getClass());
    private AvailableScheduleDao availableScheduleDao;

    @Autowired
    public void setAvailableScheduleDao(AvailableScheduleDao availableScheduleDao) {
        this.availableScheduleDao = availableScheduleDao;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView displaySchedule(@RequestParam(value="startDate", required=false) String startParam, HttpServletResponse response) throws NotRegisteredException {
        CalendarAccountUserDetails currentUser = (CalendarAccountUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        IScheduleOwner owner = currentUser.getScheduleOwner();
        Date startDate = new Date();
        if (null != startParam) {
            SimpleDateFormat df = CommonDateOperations.getDateFormat();
            try {
                startDate = df.parse(startParam);
            }
            catch (ParseException e) {
                this.LOG.debug((Object)("ignoring unparseable startDate: " + startDate));
            }
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        Date weekStart = CommonDateOperations.calculateSundayPrior((Date)startDate);
        Date weekEnd = DateUtils.addDays((Date)weekStart, (int)6);
        model.put("weekStart", weekStart);
        model.put("weekEnd", weekEnd);
        Date prevWeekStart = DateUtils.addDays((Date)weekStart, (int)-7);
        model.put("prevWeekStart", prevWeekStart);
        Date nextWeekStart = DateUtils.addDays((Date)weekEnd, (int)1);
        model.put("nextWeekStart", nextWeekStart);
        model.put("defaultMeetingLocation", owner.getPreferredLocation());
        AvailableSchedule schedule = this.availableScheduleDao.retrieveWeeklySchedule(owner, weekStart);
        SortedSet blocks = AvailableBlockBuilder.combine((SortedSet)schedule.getAvailableBlocks());
        model.put("scheduleBlocks", blocks);
        response.setHeader("Cache-Control", "no-cache");
        return new ModelAndView("owner-schedule/schedule-noscript", "model", model);
    }
}

