/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.owner.schedule;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.jasig.schedassist.model.AvailableBlockBuilder;
import org.jasig.schedassist.model.CommonDateOperations;
import org.jasig.schedassist.model.InputFormatException;
import org.jasig.schedassist.web.owner.schedule.AvailableBlockFormBackingObject;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

public class AvailableBlockFormBackingObjectValidator
implements Validator {
    public boolean supports(Class<?> clazz) {
        return AvailableBlockFormBackingObject.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"startTimePhrase", (String)"field.required", (String)"Start time field is required.");
        AvailableBlockFormBackingObject fbo = (AvailableBlockFormBackingObject)target;
        Date startTime = null;
        Date endTime = null;
        if (StringUtils.isNotBlank((String)fbo.getStartTimePhrase())) {
            try {
                startTime = CommonDateOperations.parseDateTimePhrase((String)fbo.getStartTimePhrase());
            }
            catch (InputFormatException e) {
                errors.rejectValue("startTimePhrase", "field.parseexception", "Start time does not match expected format (YYYYmmDD-hhmm)");
            }
        }
        if (StringUtils.isNotBlank((String)fbo.getEndTimePhrase())) {
            try {
                endTime = CommonDateOperations.parseDateTimePhrase((String)fbo.getEndTimePhrase());
            }
            catch (InputFormatException e) {
                errors.rejectValue("endTimePhrase", "field.parseexception", "End time does not match expected format (YYYYmmDD-hhmm)");
            }
        }
        if (fbo.getVisitorLimit() < 1) {
            errors.rejectValue("visitorLimit", "visitorLimit.toosmall", "Visitor limit must be greater than or equal to 1.");
        }
        if (fbo.getVisitorLimit() > 99) {
            errors.rejectValue("visitorLimit", "visitorLimit.toolarge", "Maximum value for visitor limit is 99.");
        }
        if (null != startTime && null != endTime) {
            try {
                AvailableBlockBuilder.createBlock((String)fbo.getStartTimePhrase(), (String)fbo.getEndTimePhrase());
            }
            catch (InputFormatException e) {
                errors.reject("field.inputformatexception", e.getMessage());
            }
        }
    }
}

