/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.owner.schedule;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.impl.owner.AvailableScheduleDao;
import org.jasig.schedassist.impl.owner.NotRegisteredException;
import org.jasig.schedassist.model.AvailableSchedule;
import org.jasig.schedassist.model.CommonDateOperations;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.InputFormatException;
import org.jasig.schedassist.web.owner.schedule.ClearAvailableScheduleFormBackingObject;
import org.jasig.schedassist.web.owner.schedule.ClearAvailableScheduleFormBackingObjectValidator;
import org.jasig.schedassist.web.security.CalendarAccountUserDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@RequestMapping(value={"/owner/clear-week.html", "/delegate/clear-week.html"})
public class ClearWeekFormController {
    private Log LOG = LogFactory.getLog(this.getClass());
    private AvailableScheduleDao availableScheduleDao;

    @Autowired
    public void setAvailableScheduleDao(AvailableScheduleDao availableScheduleDao) {
        this.availableScheduleDao = availableScheduleDao;
    }

    @InitBinder
    protected void initBinder(WebDataBinder binder) {
        binder.setValidator((Validator)new ClearAvailableScheduleFormBackingObjectValidator());
    }

    @RequestMapping(method={RequestMethod.GET})
    protected String setupForm(@RequestParam(value="weekOf", required=false) String weekOfPhrase, ModelMap model) {
        ClearAvailableScheduleFormBackingObject fbo = new ClearAvailableScheduleFormBackingObject();
        if (StringUtils.isBlank((String)weekOfPhrase)) {
            SimpleDateFormat df = CommonDateOperations.getDateFormat();
            weekOfPhrase = df.format(CommonDateOperations.calculateSundayPrior((Date)new Date()));
        }
        fbo.setWeekOfPhrase(weekOfPhrase);
        model.addAttribute("command", (Object)fbo);
        return "owner-schedule/clear-week-form";
    }

    @RequestMapping(method={RequestMethod.POST})
    protected ModelAndView clearWeek(@Valid ClearAvailableScheduleFormBackingObject fbo) throws NotRegisteredException, InputFormatException {
        CalendarAccountUserDetails currentUser = (CalendarAccountUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        IScheduleOwner owner = currentUser.getScheduleOwner();
        if (fbo.isConfirmedCancelWeek()) {
            Date weekOf = CommonDateOperations.parseDatePhrase((String)fbo.getWeekOfPhrase());
            AvailableSchedule scheduleWeekOf = this.availableScheduleDao.retrieveWeeklySchedule(owner, weekOf);
            this.availableScheduleDao.removeFromSchedule(owner, (Set)scheduleWeekOf.getAvailableBlocks());
            HashMap<String, Date> model = new HashMap<String, Date>();
            model.put("weekOf", weekOf);
            return new ModelAndView("owner-schedule/clear-week-success", model);
        }
        this.LOG.info((Object)("owner (" + owner + ") did not confirm request to clear schedule for weekOf " + fbo.getWeekOfPhrase() + ", cancelling"));
        return new ModelAndView((View)new RedirectView("schedule.html", true));
    }
}

