/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.profiles;

import java.util.Collections;
import java.util.List;
import org.jasig.schedassist.model.PublicProfileId;

public class ProfilePageInformation {
    public static int DEFAULT_RESULTS_PER_PAGE = 10;
    private int startIndex = 0;
    private int endIndex = DEFAULT_RESULTS_PER_PAGE;
    private boolean showPrev = false;
    private boolean showNext = false;
    private int showPrevIndex = 0;
    private int showNextIndex = DEFAULT_RESULTS_PER_PAGE;
    private final List<PublicProfileId> sublist;

    public ProfilePageInformation(List<PublicProfileId> profileIds, int requestedStartIndex) {
        if (requestedStartIndex >= profileIds.size()) {
            requestedStartIndex = profileIds.size() - DEFAULT_RESULTS_PER_PAGE;
            this.endIndex = profileIds.size();
        } else {
            int tempEndIndex = requestedStartIndex + DEFAULT_RESULTS_PER_PAGE;
            this.endIndex = tempEndIndex > profileIds.size() ? profileIds.size() : tempEndIndex;
        }
        this.startIndex = requestedStartIndex < 0 ? 0 : requestedStartIndex;
        if (this.endIndex < profileIds.size()) {
            this.showNext = true;
            this.showNextIndex = this.endIndex;
        }
        if (this.startIndex > 0) {
            this.showPrev = true;
            this.showPrevIndex = this.startIndex - DEFAULT_RESULTS_PER_PAGE;
            if (this.showPrevIndex < 0) {
                this.showPrevIndex = 0;
            }
        }
        this.sublist = Collections.unmodifiableList(profileIds.subList(this.startIndex, this.endIndex));
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public boolean isShowPrev() {
        return this.showPrev;
    }

    public boolean isShowNext() {
        return this.showNext;
    }

    public List<PublicProfileId> getSublist() {
        return this.sublist;
    }

    public int getShowPrevIndex() {
        return this.showPrevIndex;
    }

    public int getShowNextIndex() {
        return this.showNextIndex;
    }
}

