/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jasig.schedassist.impl.owner.NotRegisteredException;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.IDelegateCalendarAccount;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.web.security.CalendarAccountUserDetails;
import org.jasig.schedassist.web.security.SecurityConstants;
import org.springframework.security.core.GrantedAuthority;

public class DelegateCalendarAccountUserDetailsImpl
implements CalendarAccountUserDetails {
    private static final long serialVersionUID = 53706L;
    private static final String EMPTY = "";
    private final IDelegateCalendarAccount delegateCalendarAccount;
    private IScheduleOwner scheduleOwner;

    DelegateCalendarAccountUserDetailsImpl(IDelegateCalendarAccount delegateCalendarAccount) {
        this(delegateCalendarAccount, null);
    }

    DelegateCalendarAccountUserDetailsImpl(IDelegateCalendarAccount delegateCalendarAccount, IScheduleOwner delegateScheduleOwner) {
        this.delegateCalendarAccount = delegateCalendarAccount;
        this.scheduleOwner = delegateScheduleOwner;
    }

    public Collection<GrantedAuthority> getAuthorities() {
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        if (null != this.delegateCalendarAccount && this.delegateCalendarAccount.isEligible()) {
            authorities.add(SecurityConstants.DELEGATE_REGISTER);
        }
        if (null != this.scheduleOwner) {
            authorities.add(SecurityConstants.DELEGATE_OWNER);
            authorities.remove(SecurityConstants.DELEGATE_REGISTER);
        }
        return Collections.unmodifiableList(authorities);
    }

    public String getPassword() {
        return EMPTY;
    }

    public String getUsername() {
        return this.delegateCalendarAccount.getUsername();
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return null != this.delegateCalendarAccount ? this.delegateCalendarAccount.isEligible() : false;
    }

    @Override
    public String getActiveDisplayName() {
        StringBuilder display = new StringBuilder();
        display.append(this.delegateCalendarAccount.getDisplayName());
        display.append(" (managed by ");
        display.append(this.delegateCalendarAccount.getAccountOwnerUsername());
        display.append(")");
        return display.toString();
    }

    @Override
    public ICalendarAccount getCalendarAccount() {
        return this.getDelegateCalendarAccount();
    }

    public IDelegateCalendarAccount getDelegateCalendarAccount() {
        return this.delegateCalendarAccount;
    }

    @Override
    public IScheduleOwner getScheduleOwner() throws NotRegisteredException {
        if (null == this.scheduleOwner) {
            throw new NotRegisteredException(this.delegateCalendarAccount + " is not registered");
        }
        return this.scheduleOwner;
    }

    @Override
    public final boolean isDelegate() {
        return true;
    }

    @Override
    public void updateScheduleOwner(IScheduleOwner owner) {
        this.scheduleOwner = owner;
    }
}

