/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.admin;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.ICalendarAccountDao;
import org.jasig.schedassist.IDelegateCalendarAccountDao;
import org.jasig.schedassist.impl.owner.OwnerDao;
import org.jasig.schedassist.impl.visitor.NotAVisitorException;
import org.jasig.schedassist.impl.visitor.VisitorDao;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.IScheduleVisitor;
import org.jasig.schedassist.web.admin.AccountLookupFormBackingObject;
import org.jasig.schedassist.web.admin.VisibleScheduleDebugFormBackingObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

@Component
public class VisibleScheduleDebugFormBackingObjectValidator
implements Validator {
    private Log LOG = LogFactory.getLog(this.getClass());
    private ICalendarAccountDao calendarAccountDao;
    private IDelegateCalendarAccountDao delegateCalendarAccountDao;
    private OwnerDao ownerDao;
    private VisitorDao visitorDao;

    @Autowired
    public void setCalendarAccountDao(@Qualifier(value="people") ICalendarAccountDao calendarAccountDao) {
        this.calendarAccountDao = calendarAccountDao;
    }

    @Autowired
    public void setDelegateCalendarAccountDao(@Qualifier(value="delegates") IDelegateCalendarAccountDao delegateCalendarAccountDao) {
        this.delegateCalendarAccountDao = delegateCalendarAccountDao;
    }

    @Autowired
    public void setOwnerDao(OwnerDao ownerDao) {
        this.ownerDao = ownerDao;
    }

    @Autowired
    public void setVisitorDao(VisitorDao visitorDao) {
        this.visitorDao = visitorDao;
    }

    public boolean supports(Class<?> clazz) {
        return VisibleScheduleDebugFormBackingObject.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        VisibleScheduleDebugFormBackingObject command = (VisibleScheduleDebugFormBackingObject)target;
        IScheduleVisitor visitor = this.locateVisitor(command.getVisitorLookup());
        if (visitor == null) {
            errors.rejectValue("visitorLookup", "visitor.notfound", "Schedule Visitor not found");
        } else {
            command.setScheduleVisitor(visitor);
        }
        IScheduleOwner owner = this.locateOwner(command.getOwnerLookup());
        if (owner == null) {
            errors.rejectValue("ownerLookup", "owner.notfound", "Schedule Owner not found");
        } else {
            command.setScheduleOwner(owner);
        }
    }

    protected IScheduleVisitor locateVisitor(AccountLookupFormBackingObject lookupObject) {
        ICalendarAccount account = null;
        if (StringUtils.isNotBlank((String)lookupObject.getUsername())) {
            account = this.calendarAccountDao.getCalendarAccount(lookupObject.getUsername());
        } else if (StringUtils.isNotBlank((String)lookupObject.getCtcalxitemid())) {
            account = this.calendarAccountDao.getCalendarAccountFromUniqueId(lookupObject.getCtcalxitemid());
        }
        if (null != account) {
            try {
                return this.visitorDao.toVisitor(account);
            }
            catch (NotAVisitorException e) {
                this.LOG.debug((Object)(account + " not a visitor"), (Throwable)e);
            }
        }
        return null;
    }

    protected IScheduleOwner locateOwner(AccountLookupFormBackingObject lookupObject) {
        ICalendarAccount account = null;
        if (StringUtils.isNotBlank((String)lookupObject.getUsername())) {
            account = this.calendarAccountDao.getCalendarAccount(lookupObject.getUsername());
        } else if (StringUtils.isNotBlank((String)lookupObject.getCtcalxitemid())) {
            account = this.calendarAccountDao.getCalendarAccountFromUniqueId(lookupObject.getCtcalxitemid());
        } else if (StringUtils.isNotBlank((String)lookupObject.getResourceName())) {
            account = this.delegateCalendarAccountDao.getDelegate(lookupObject.getResourceName());
        }
        if (null != account) {
            IScheduleOwner owner = this.ownerDao.locateOwner(account);
            return owner;
        }
        return null;
    }
}

