/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.owner.relationships;

import au.com.bytecode.opencsv.CSVReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jasig.schedassist.ICalendarAccountDao;
import org.jasig.schedassist.MutableRelationshipDao;
import org.jasig.schedassist.impl.owner.NotRegisteredException;
import org.jasig.schedassist.impl.visitor.NotAVisitorException;
import org.jasig.schedassist.impl.visitor.VisitorDao;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.IScheduleVisitor;
import org.jasig.schedassist.model.Relationship;
import org.jasig.schedassist.web.owner.relationships.CSVFileImportResult;
import org.jasig.schedassist.web.owner.relationships.ModifyAdhocRelationshipFormBackingObject;
import org.jasig.schedassist.web.owner.relationships.ModifyAdhocRelationshipFormBackingObjectValidator;
import org.jasig.schedassist.web.security.CalendarAccountUserDetails;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.DirectFieldBindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/owner/create-relationships-import.html", "/delegate/create-relationships-import.html"})
public class CSVFileImportFormController
implements DisposableBean {
    public static final String IMPORT_FUTURE_NAME = CSVFileImportFormController.class.getPackage().getName() + ".SharingFileImportFormController.IMPORT_FUTURE";
    private String statusViewName = "owner-relationships/csv-import-status";
    private String formViewName = "owner-relationships/csv-import-form";
    private ExecutorService executorService;
    private MutableRelationshipDao mutableRelationshipDao;
    private VisitorDao visitorDao;
    private ICalendarAccountDao calendarAccountDao;

    @Autowired
    public void setExecutorService(@Qualifier(value="fileImportExecutorService") ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Autowired
    public void setMutableRelationshipDao(MutableRelationshipDao mutableRelationshipDao) {
        this.mutableRelationshipDao = mutableRelationshipDao;
    }

    @Autowired
    public void setVisitorDao(VisitorDao visitorDao) {
        this.visitorDao = visitorDao;
    }

    @Autowired
    public void setCalendarAccountDao(ICalendarAccountDao calendarAccountDao) {
        this.calendarAccountDao = calendarAccountDao;
    }

    public void destroy() throws Exception {
        this.executorService.shutdownNow();
    }

    @RequestMapping(method={RequestMethod.POST})
    protected String uploadFile(ModelMap model, @RequestParam(value="file") MultipartFile file, HttpServletRequest request) throws NotRegisteredException {
        CalendarAccountUserDetails currentUser = (CalendarAccountUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        IScheduleOwner owner = currentUser.getScheduleOwner();
        FileImportCallable callable = new FileImportCallable(file, this.calendarAccountDao, this.visitorDao, owner, this.mutableRelationshipDao);
        Future<CSVFileImportResult> f = this.executorService.submit(callable);
        request.getSession(true).setAttribute(IMPORT_FUTURE_NAME, f);
        model.addAttribute("submitted", (Object)true);
        return this.statusViewName;
    }

    @RequestMapping(method={RequestMethod.GET})
    protected String showForm(ModelMap model, HttpServletRequest request, @RequestParam(value="dismiss", required=false, defaultValue="false") boolean dismiss) throws InterruptedException, ExecutionException, NotRegisteredException {
        HttpSession currentSession = request.getSession();
        if (null != currentSession) {
            Future f;
            if (dismiss) {
                currentSession.setAttribute(IMPORT_FUTURE_NAME, null);
            }
            if (null != (f = (Future)currentSession.getAttribute(IMPORT_FUTURE_NAME))) {
                if (f.isDone()) {
                    CSVFileImportResult importResult = (CSVFileImportResult)f.get();
                    model.addAttribute("processing", (Object)false);
                    model.addAttribute("importResult", (Object)importResult);
                    currentSession.setAttribute(IMPORT_FUTURE_NAME, null);
                    return this.statusViewName;
                }
                model.addAttribute("processing", (Object)true);
                return this.statusViewName;
            }
        }
        return this.formViewName;
    }

    static class FileImportCallable
    implements Callable<CSVFileImportResult> {
        private MultipartFile file;
        private ICalendarAccountDao calendarAccountDao;
        private VisitorDao visitorDao;
        private IScheduleOwner scheduleOwner;
        private MutableRelationshipDao mutableRelationshipDao;
        private final ModifyAdhocRelationshipFormBackingObjectValidator validator;

        public FileImportCallable(MultipartFile file, ICalendarAccountDao calendarAccountDao, VisitorDao visitorDao, IScheduleOwner scheduleOwner, MutableRelationshipDao mutableRelationshipDao) {
            this.file = file;
            this.visitorDao = visitorDao;
            this.calendarAccountDao = calendarAccountDao;
            this.scheduleOwner = scheduleOwner;
            this.mutableRelationshipDao = mutableRelationshipDao;
            this.validator = new ModifyAdhocRelationshipFormBackingObjectValidator(this.calendarAccountDao);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public CSVFileImportResult call() throws Exception {
            CSVFileImportResult result = new CSVFileImportResult();
            List<ModifyAdhocRelationshipFormBackingObject> fileData = this.parseUploadedFile(this.file, result);
            int lineNumber = 1;
            Iterator<ModifyAdhocRelationshipFormBackingObject> i$ = fileData.iterator();
            while (i$.hasNext()) {
                ModifyAdhocRelationshipFormBackingObject fbo = i$.next();
                DirectFieldBindingResult errors = new DirectFieldBindingResult((Object)fbo, "command");
                this.validator.validate(fbo, (Errors)errors);
                if (!errors.hasErrors()) {
                    ICalendarAccount visitorUser = this.calendarAccountDao.getCalendarAccount(fbo.getVisitorUsername());
                    if (null == visitorUser) {
                        result.storeFailure(lineNumber, fbo.getVisitorUsername(), "Account not eligible for WiscCal");
                    }
                    try {
                        IScheduleVisitor visitor = this.visitorDao.toVisitor(visitorUser);
                        Relationship r = this.mutableRelationshipDao.createRelationship(this.scheduleOwner, visitor, fbo.getRelationship());
                        if (null != r) {
                            result.incrementSuccess();
                        }
                    }
                    catch (NotAVisitorException e) {
                        result.storeFailure(lineNumber, fbo.getVisitorUsername(), "Account not eligible for WiscCal Scheduling Assistant");
                    }
                } else {
                    for (ObjectError o : errors.getAllErrors()) {
                        FieldError error = (FieldError)o;
                        if ("visitor.notfound".equals(error.getCode())) {
                            result.storeFailure(lineNumber, fbo.getVisitorUsername(), error.getDefaultMessage());
                            continue;
                        }
                        result.storeFailure(lineNumber, error.getDefaultMessage());
                    }
                }
                ++lineNumber;
            }
            return result;
        }

        private List<ModifyAdhocRelationshipFormBackingObject> parseUploadedFile(MultipartFile file, CSVFileImportResult importResult) throws IOException {
            HashSet<String> usernames = new HashSet<String>();
            ArrayList<ModifyAdhocRelationshipFormBackingObject> results = new ArrayList<ModifyAdhocRelationshipFormBackingObject>();
            CSVReader lineReader = new CSVReader((Reader)new InputStreamReader(file.getInputStream()));
            String[] tokens = lineReader.readNext();
            int lineNumber = 1;
            while (null != tokens) {
                if (tokens.length == 2) {
                    if (usernames.contains(tokens[0])) {
                        importResult.storeFailure(lineNumber, tokens[0], "Duplicate username found, using latest relationship description: " + tokens[1]);
                    } else {
                        usernames.add(tokens[0]);
                    }
                    ModifyAdhocRelationshipFormBackingObject fbo = new ModifyAdhocRelationshipFormBackingObject();
                    fbo.setRelationship(tokens[1]);
                    fbo.setVisitorUsername(tokens[0]);
                    results.add(fbo);
                } else {
                    importResult.storeFailure(lineNumber, "Line does not match expected format (netid, description)");
                }
                tokens = lineReader.readNext();
                ++lineNumber;
            }
            return results;
        }
    }
}

