/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.owner.schedule;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.SortedSet;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.impl.owner.AvailableScheduleDao;
import org.jasig.schedassist.impl.owner.NotRegisteredException;
import org.jasig.schedassist.model.AvailableBlock;
import org.jasig.schedassist.model.AvailableBlockBuilder;
import org.jasig.schedassist.model.AvailableSchedule;
import org.jasig.schedassist.model.CommonDateOperations;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.web.security.CalendarAccountUserDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/owner/schedule-data.json", "/delegate/schedule-data.json"})
public class AvailableScheduleDataController {
    private Log LOG = LogFactory.getLog(this.getClass());
    private AvailableScheduleDao availableScheduleDao;

    @Autowired
    public void setAvailableScheduleDao(AvailableScheduleDao availableScheduleDao) {
        this.availableScheduleDao = availableScheduleDao;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String getAvailableSchedule(@RequestParam(value="startDate", required=false) String startParam, ModelMap model, HttpServletResponse response) throws NotRegisteredException {
        CalendarAccountUserDetails currentUser = (CalendarAccountUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        IScheduleOwner owner = currentUser.getScheduleOwner();
        Date startDate = new Date();
        if (StringUtils.isNotBlank((String)startParam)) {
            SimpleDateFormat df = CommonDateOperations.getDateFormat();
            try {
                startDate = df.parse(startParam);
            }
            catch (ParseException e) {
                this.LOG.debug((Object)("ignoring unparseable startDate: " + startDate));
            }
        }
        Date weekStart = CommonDateOperations.calculateSundayPrior((Date)startDate);
        Date weekEnd = DateUtils.addDays((Date)weekStart, (int)6);
        model.addAttribute("weekStart", (Object)this.formatDate(weekStart));
        model.addAttribute("weekEnd", (Object)this.formatDate(weekEnd));
        AvailableSchedule schedule = this.availableScheduleDao.retrieveWeeklySchedule(owner, weekStart);
        model.addAttribute("scheduleBlocks", AvailableScheduleDataController.formatJson(schedule));
        model.addAttribute("defaultMeetingLocation", (Object)owner.getPreferredLocation());
        response.setHeader("Cache-Control", "max-age=0,no-cache,no-store,post-check=0,pre-check=0");
        response.setHeader("Expires", "Fri, 31 Jan 1997 05:00:00 GMT");
        return "jsonView";
    }

    public static List<AvailableBlockJsonRepresentation> formatJson(AvailableSchedule schedule) {
        ArrayList<AvailableBlockJsonRepresentation> results = new ArrayList<AvailableBlockJsonRepresentation>();
        SortedSet combined = AvailableBlockBuilder.combine((SortedSet)schedule.getAvailableBlocks());
        for (AvailableBlock block : combined) {
            results.add(new AvailableBlockJsonRepresentation(block));
        }
        return results;
    }

    public static Date roundDownToNearest15(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int minutesField = cal.get(12);
        int toRemove = minutesField % 15;
        Date result = date;
        if (toRemove != 0) {
            result = DateUtils.addMinutes((Date)result, (int)(-toRemove));
        }
        return result;
    }

    private String formatDate(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("MMM d, yyyy");
        return df.format(date);
    }

    public static class AvailableBlockJsonRepresentation {
        public static final String DATETIME_FORMAT = "EEEHHmm";
        static final FastDateFormat dateFormat = FastDateFormat.getInstance((String)"EEEHHmm");
        private final AvailableBlock block;
        private final Date startTimeRounded;

        public AvailableBlockJsonRepresentation(AvailableBlock block) {
            this.block = block;
            this.startTimeRounded = AvailableScheduleDataController.roundDownToNearest15(block.getStartTime());
        }

        public String getStartTime() {
            return dateFormat.format(this.startTimeRounded);
        }

        public int getDurationIn15Mins() {
            SortedSet expanded = AvailableBlockBuilder.expand((AvailableBlock)this.block, (int)15);
            int blockSize = expanded.size();
            if (!this.block.getStartTime().equals(this.startTimeRounded)) {
                ++blockSize;
            }
            return blockSize;
        }

        public int getVisitorLimit() {
            return this.block.getVisitorLimit();
        }

        public String getMeetingLocation() {
            return this.block.getMeetingLocation();
        }
    }
}

