/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.owner.schedule;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jasig.schedassist.model.AvailableBlockBuilder;
import org.jasig.schedassist.model.CommonDateOperations;
import org.jasig.schedassist.model.InputFormatException;
import org.jasig.schedassist.web.owner.schedule.BlockBuilderFormBackingObject;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

public class BlockBuilderFormBackingObjectValidator
implements Validator {
    private static final long MILLISECS_PER_MIN = 60000L;
    protected static final String DAYS_OF_WEEK_REGEX = "[nmtwrfs]+";
    protected static final String DATE_REGEX = "(\\d{1,2})/\\d{1,2}/\\d{4}";
    protected static final String TIME_REGEX = "(\\d{1,2}):([0-5]\\d{1}) ([AP]M)";
    protected static final Pattern DAYS_OF_WEEK_PATTERN = Pattern.compile("[nmtwrfs]+", 2);
    protected static final Pattern DATE_PATTERN = Pattern.compile("(\\d{1,2})/\\d{1,2}/\\d{4}", 2);
    protected static final Pattern TIME_PATTERN = Pattern.compile("(\\d{1,2}):([0-5]\\d{1}) ([AP]M)", 2);
    private static final String AM = "AM";
    private static final String PM = "PM";

    public boolean supports(Class<?> clazz) {
        return BlockBuilderFormBackingObject.class.equals(clazz);
    }

    public void validate(Object command, Errors errors) {
        long minutesDifference;
        Matcher m;
        Matcher daysMatcher;
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"startTimePhrase", (String)"field.required", (String)"Start time field is required.");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"endTimePhrase", (String)"field.required", (String)"End time field is required.");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"daysOfWeekPhrase", (String)"field.required", (String)"Days of week field is required.");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"startDatePhrase", (String)"field.required", (String)"Start date field is required.");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"endDatePhrase", (String)"field.required", (String)"End date field is required.");
        BlockBuilderFormBackingObject fbo = (BlockBuilderFormBackingObject)command;
        if (!StringUtils.isBlank((String)fbo.getDaysOfWeekPhrase()) && !(daysMatcher = DAYS_OF_WEEK_PATTERN.matcher(fbo.getDaysOfWeekPhrase())).matches()) {
            errors.rejectValue("daysOfWeekPhrase", "invalid.daysOfWeekPhrase", "Days of week must contain only 'NMTWRFS' (N is Sunday, S is Saturday).");
        }
        if (!StringUtils.isBlank((String)fbo.getStartDatePhrase()) && !(m = DATE_PATTERN.matcher(fbo.getStartDatePhrase())).matches()) {
            errors.rejectValue("startDatePhrase", "startDatePhrase.invalidFormat", "Start Date must contain 2 digit month, 2 digit day, and 4 digit year (mm/dd/yyyy).");
        }
        if (!StringUtils.isBlank((String)fbo.getEndDatePhrase()) && !(m = DATE_PATTERN.matcher(fbo.getEndDatePhrase())).matches()) {
            errors.rejectValue("endDatePhrase", "endDatePhrase.invalidFormat", "End Date must contain 2 digit month, 2 digit day, and 4 digit year (mm/dd/yyyy).");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
        Date startDate = null;
        Date endDate = null;
        if (!StringUtils.isBlank((String)fbo.getStartDatePhrase())) {
            try {
                startDate = dateFormat.parse(fbo.getStartDatePhrase());
            }
            catch (ParseException e) {
                errors.rejectValue("startDatePhrase", "field.parseexception", "Start date does not match expected format (mm/dd/yyyy).");
            }
        }
        if (!StringUtils.isBlank((String)fbo.getEndDatePhrase())) {
            try {
                endDate = dateFormat.parse(fbo.getEndDatePhrase());
            }
            catch (ParseException e) {
                errors.rejectValue("endDatePhrase", "field.parseexception", "End date does not match expected format (mm/dd/yyyy).");
            }
        }
        if (null != startDate && null != endDate && CommonDateOperations.approximateDifference((Date)startDate, (Date)endDate) > 730L) {
            errors.rejectValue("endDatePhrase", "endDatePhrase.toofarout", "End date is more than 2 years after startDate; please scale back your end date.");
        }
        boolean startTimePhraseValid = true;
        boolean endTimePhraseValid = true;
        Matcher startTimeMatcher = null;
        if (!StringUtils.isBlank((String)fbo.getStartTimePhrase())) {
            startTimeMatcher = TIME_PATTERN.matcher(fbo.getStartTimePhrase());
            if (!startTimeMatcher.matches()) {
                errors.rejectValue("startTimePhrase", "field.timeparseexception", "Start time does not match expected format (hh:mm am|pm).");
                startTimePhraseValid = false;
            } else if (Integer.parseInt(startTimeMatcher.group(1)) > 12) {
                errors.rejectValue("startTimePhrase", "field.militarytime", "Start time should start with a number between 1 and 12; do not use military time.");
                startTimePhraseValid = false;
            }
        } else {
            startTimePhraseValid = false;
        }
        Matcher endTimeMatcher = null;
        if (!StringUtils.isBlank((String)fbo.getEndTimePhrase())) {
            endTimeMatcher = TIME_PATTERN.matcher(fbo.getEndTimePhrase());
            if (!endTimeMatcher.matches()) {
                errors.rejectValue("endTimePhrase", "field.timeparseexception", "End time does not match expected format (hh:mm am|pm).");
                endTimePhraseValid = false;
            } else if (Integer.parseInt(endTimeMatcher.group(1)) > 12) {
                errors.rejectValue("endTimePhrase", "field.militarytime", "End time should start with a number between 1 and 12; do not use military time.");
                endTimePhraseValid = false;
            }
        } else {
            endTimePhraseValid = false;
        }
        if (startTimePhraseValid && endTimePhraseValid && (minutesDifference = this.approximateMinutesDifference(startTimeMatcher, endTimeMatcher)) < 15L) {
            errors.rejectValue("endTimePhrase", "endTimePhrase.tooshort", "End time has to be at least 15 minutes later than the start time.");
        }
        if (fbo.getVisitorsPerAppointment() < 1) {
            errors.rejectValue("visitorsPerAppointment", "visitors.toosmall", "Visitors per appointment must be greater than or equal to 1.");
        }
        if (fbo.getVisitorsPerAppointment() > 99) {
            errors.rejectValue("visitorsPerAppointment", "visitors.toosmall", "Maximum allowed value for visitors per appointment is 99.");
        }
        if (StringUtils.isBlank((String)fbo.getMeetingLocation())) {
            fbo.setMeetingLocation(null);
        } else if (fbo.getMeetingLocation().length() > 100) {
            errors.rejectValue("location", "location.toolong", "Location field is too long (" + fbo.getMeetingLocation().length() + "); maximum length is 100 characters.");
        }
        if (!errors.hasErrors()) {
            try {
                if (null != startDate && null != endDate) {
                    AvailableBlockBuilder.createBlocks((String)fbo.getStartTimePhrase(), (String)fbo.getEndTimePhrase(), (String)fbo.getDaysOfWeekPhrase(), (Date)startDate, (Date)endDate);
                }
            }
            catch (InputFormatException e) {
                errors.reject("createBlocksFailed", e.getMessage());
            }
        }
    }

    private long approximateMinutesDifference(Matcher startTimeMatcher, Matcher endTimeMatcher) {
        Date now = new Date();
        Calendar s = Calendar.getInstance();
        s.setTime(now);
        s.set(11, this.convertHourOfDay(startTimeMatcher));
        s.set(12, Integer.parseInt(startTimeMatcher.group(2)));
        Calendar e = Calendar.getInstance();
        e.setTime(now);
        e.set(11, this.convertHourOfDay(endTimeMatcher));
        e.set(12, Integer.parseInt(endTimeMatcher.group(2)));
        long endL = e.getTimeInMillis() + (long)e.getTimeZone().getOffset(e.getTimeInMillis());
        long startL = s.getTimeInMillis() + (long)s.getTimeZone().getOffset(s.getTimeInMillis());
        return (endL - startL) / 60000L;
    }

    private int convertHourOfDay(Matcher m) {
        String hourString = m.group(1);
        int hour = Integer.parseInt(hourString);
        String ampm = m.group(3);
        if (hour == 12 && AM.equalsIgnoreCase(ampm)) {
            return 0;
        }
        if (hour != 12 && PM.equalsIgnoreCase(ampm)) {
            return hour + 12;
        }
        return hour;
    }
}

