/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.remoting.soap;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javax.xml.datatype.XMLGregorianCalendar;
import net.fortuna.ical4j.model.component.VEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.CalendarAccountNotFoundException;
import org.jasig.schedassist.ICalendarAccountDao;
import org.jasig.schedassist.RelationshipDao;
import org.jasig.schedassist.SchedulingAssistantService;
import org.jasig.schedassist.SchedulingException;
import org.jasig.schedassist.impl.owner.AvailableScheduleDao;
import org.jasig.schedassist.impl.owner.NotRegisteredException;
import org.jasig.schedassist.impl.owner.OwnerDao;
import org.jasig.schedassist.impl.visitor.NotAVisitorException;
import org.jasig.schedassist.impl.visitor.VisitorDao;
import org.jasig.schedassist.messaging.AvailableBlockElement;
import org.jasig.schedassist.messaging.AvailableBlockList;
import org.jasig.schedassist.messaging.AvailableStatusType;
import org.jasig.schedassist.messaging.CancelAppointmentRequest;
import org.jasig.schedassist.messaging.CancelAppointmentResponse;
import org.jasig.schedassist.messaging.CreateAppointmentRequest;
import org.jasig.schedassist.messaging.CreateAppointmentResponse;
import org.jasig.schedassist.messaging.GetRelationshipsRequest;
import org.jasig.schedassist.messaging.GetRelationshipsResponse;
import org.jasig.schedassist.messaging.GetScheduleOwnerByIdRequest;
import org.jasig.schedassist.messaging.GetScheduleOwnerByIdResponse;
import org.jasig.schedassist.messaging.GetTargetAvailableBlockRequest;
import org.jasig.schedassist.messaging.GetTargetAvailableBlockResponse;
import org.jasig.schedassist.messaging.IsEligibleRequest;
import org.jasig.schedassist.messaging.IsEligibleResponse;
import org.jasig.schedassist.messaging.PreferencesElement;
import org.jasig.schedassist.messaging.PreferencesSet;
import org.jasig.schedassist.messaging.RelationshipElement;
import org.jasig.schedassist.messaging.RelationshipList;
import org.jasig.schedassist.messaging.ScheduleOwnerElement;
import org.jasig.schedassist.messaging.VisibleScheduleRequest;
import org.jasig.schedassist.messaging.VisibleScheduleResponse;
import org.jasig.schedassist.messaging.VisitorConflictsRequest;
import org.jasig.schedassist.messaging.VisitorConflictsResponse;
import org.jasig.schedassist.messaging.XMLDataUtils;
import org.jasig.schedassist.model.AvailableBlock;
import org.jasig.schedassist.model.AvailableStatus;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.IScheduleVisitor;
import org.jasig.schedassist.model.InputFormatException;
import org.jasig.schedassist.model.MeetingDurations;
import org.jasig.schedassist.model.Preferences;
import org.jasig.schedassist.model.Relationship;
import org.jasig.schedassist.model.VisibleSchedule;
import org.jasig.schedassist.model.VisibleScheduleRequestConstraints;
import org.jasig.schedassist.remoting.soap.SOAPSchedulingAssistantOperations;
import org.jasig.schedassist.remoting.soap.SOAPSchedulingAssistantServiceEndpoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.ws.server.endpoint.annotation.Endpoint;
import org.springframework.ws.server.endpoint.annotation.PayloadRoot;

/*
 * Exception performing whole class analysis ignored.
 */
@Endpoint(value="schedulingAssistantEndpoint")
public class SOAPSchedulingAssistantServiceEndpoint
implements SOAPSchedulingAssistantOperations {
    private Log LOG = LogFactory.getLog(this.getClass());
    private SchedulingAssistantService schedulingAssistantService;
    private ICalendarAccountDao calendarAccountDao;
    private OwnerDao ownerDao;
    private VisitorDao visitorDao;
    private RelationshipDao relationshipDao;
    private AvailableScheduleDao availableScheduleDao;

    @Autowired
    public void setAvailableService(SchedulingAssistantService schedulingAssistantService) {
        this.schedulingAssistantService = schedulingAssistantService;
    }

    @Autowired
    public void setCalendarAccountDao(ICalendarAccountDao calendarAccountDao) {
        this.calendarAccountDao = calendarAccountDao;
    }

    @Autowired
    public void setOwnerDao(OwnerDao ownerDao) {
        this.ownerDao = ownerDao;
    }

    @Autowired
    public void setVisitorDao(VisitorDao visitorDao) {
        this.visitorDao = visitorDao;
    }

    @Autowired
    public void setRelationshipDao(@Qualifier(value="composite") RelationshipDao relationshipDao) {
        this.relationshipDao = relationshipDao;
    }

    @Autowired
    public void setAvailableScheduleDao(AvailableScheduleDao availableScheduleDao) {
        this.availableScheduleDao = availableScheduleDao;
    }

    @PayloadRoot(localPart="IsEligibleRequest", namespace="https://source.jasig.org/schemas/sched-assist")
    public IsEligibleResponse isEligible(IsEligibleRequest request) {
        boolean eligible = false;
        IsEligibleResponse response = new IsEligibleResponse();
        ICalendarAccount account = this.calendarAccountDao.getCalendarAccount(request.getVisitorNetid());
        if (null != account) {
            try {
                this.visitorDao.toVisitor(account);
                eligible = true;
            }
            catch (NotAVisitorException e) {
                this.LOG.debug((Object)(request.getVisitorNetid() + " not a visitor"));
            }
        }
        response.setEligible(eligible);
        return response;
    }

    @PayloadRoot(localPart="GetTargetAvailableBlockRequest", namespace="https://source.jasig.org/schemas/sched-assist")
    public GetTargetAvailableBlockResponse getTargetAvailableBlock(GetTargetAvailableBlockRequest request) throws NotRegisteredException, SchedulingException {
        IScheduleOwner owner;
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)request);
        }
        if (null == (owner = this.ownerDao.locateOwnerByAvailableId(request.getOwnerId()))) {
            throw new NotRegisteredException("no schedule owner found with id " + request.getOwnerId());
        }
        Date startTime = XMLDataUtils.convertXMLGregorianCalendarToDate((XMLGregorianCalendar)request.getStartTime());
        AvailableBlock targetBlock = request.isDoubleLength() ? this.availableScheduleDao.retrieveTargetDoubleLengthBlock(owner, startTime) : this.availableScheduleDao.retrieveTargetBlock(owner, startTime);
        GetTargetAvailableBlockResponse response = new GetTargetAvailableBlockResponse();
        AvailableBlockElement element = this.createAvailableBlockElement(targetBlock);
        response.setAvailableBlockElement(element);
        return response;
    }

    @PayloadRoot(localPart="VisibleScheduleRequest", namespace="https://source.jasig.org/schemas/sched-assist")
    public VisibleScheduleResponse getVisibleSchedule(VisibleScheduleRequest request) throws NotAVisitorException, CalendarAccountNotFoundException, NotRegisteredException {
        VisibleSchedule schedule;
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)request);
        }
        ICalendarAccount visitorCalendarUser = this.calendarAccountDao.getCalendarAccount(request.getVisitorNetid());
        IScheduleVisitor visitor = this.visitorDao.toVisitor(visitorCalendarUser);
        IScheduleOwner owner = this.ownerDao.locateOwnerByAvailableId(request.getOwnerId());
        if (null == owner) {
            throw new NotRegisteredException(request.getOwnerId() + " not currently registered as a schedule owner");
        }
        VisibleScheduleRequestConstraints requestConstraints = VisibleScheduleRequestConstraints.newInstance((IScheduleOwner)owner, (int)request.getWeekStart());
        VisibleScheduleResponse response = new VisibleScheduleResponse();
        MeetingDurations ownerDurations = owner.getPreferredMeetingDurations();
        PreferencesElement durationsElement = new PreferencesElement();
        durationsElement.setKey(Preferences.DURATIONS.getKey());
        durationsElement.setValue(ownerDurations.getKey());
        response.setOwnerMeetingDurationsPreference(durationsElement);
        if (owner.hasMeetingLimit()) {
            schedule = this.schedulingAssistantService.getVisibleSchedule(visitor, owner);
            if (owner.isExceedingMeetingLimit(schedule.getAttendingCount())) {
                ArrayList<AvailableBlockElement> blockElementList = new ArrayList<AvailableBlockElement>();
                List attendingList = schedule.getAttendingList();
                for (AvailableBlock b : attendingList) {
                    AvailableBlockElement element = this.createAvailableBlockElement(b);
                    element.setStatus(AvailableStatusType.ATTENDING);
                    blockElementList.add(element);
                }
                AvailableBlockList listWrapper = new AvailableBlockList();
                listWrapper.getAvailableBlockElement().addAll(blockElementList);
                response.setAvailableBlockList(listWrapper);
                response.setMeetingLimitExceeded(true);
                return response;
            }
            schedule = schedule.subset(requestConstraints.getTargetStartDate(), requestConstraints.getTargetEndDate());
        } else {
            schedule = this.schedulingAssistantService.getVisibleSchedule(visitor, owner, requestConstraints.getTargetStartDate(), requestConstraints.getTargetEndDate());
        }
        ArrayList<AvailableBlockElement> blockElementList = new ArrayList<AvailableBlockElement>();
        SortedMap blockMap = schedule.getBlockMap();
        for (Map.Entry entry : blockMap.entrySet()) {
            AvailableBlock block = (AvailableBlock)entry.getKey();
            AvailableStatus status = (AvailableStatus)entry.getValue();
            AvailableBlockElement element = this.createAvailableBlockElement(block);
            switch (1.$SwitchMap$org$jasig$schedassist$model$AvailableStatus[status.ordinal()]) {
                case 1: {
                    element.setStatus(AvailableStatusType.FREE);
                    break;
                }
                case 2: {
                    element.setStatus(AvailableStatusType.ATTENDING);
                    break;
                }
                case 3: {
                    element.setStatus(AvailableStatusType.BUSY);
                }
            }
            blockElementList.add(element);
        }
        AvailableBlockList listWrapper = new AvailableBlockList();
        listWrapper.getAvailableBlockElement().addAll(blockElementList);
        response.setAvailableBlockList(listWrapper);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("visitor " + visitor + " requested visible schedule for owner " + owner));
        }
        return response;
    }

    @PayloadRoot(localPart="CreateAppointmentRequest", namespace="https://source.jasig.org/schemas/sched-assist")
    public CreateAppointmentResponse scheduleAppointment(CreateAppointmentRequest request) throws NotAVisitorException, InputFormatException, SchedulingException, CalendarAccountNotFoundException, NotRegisteredException {
        ICalendarAccount visitorCalendarUser = this.calendarAccountDao.getCalendarAccount(request.getVisitorNetid());
        IScheduleVisitor visitor = this.visitorDao.toVisitor(visitorCalendarUser);
        IScheduleOwner owner = this.ownerDao.locateOwnerByAvailableId(request.getOwnerId());
        if (null == owner) {
            throw new NotRegisteredException(request.getOwnerId() + " not currently registered as a schedule owner");
        }
        AvailableBlock block = this.availableScheduleDao.retrieveTargetBlock(owner, XMLDataUtils.convertXMLGregorianCalendarToDate((XMLGregorianCalendar)request.getStartTime()));
        if (null != block && block.getVisitorLimit() == 1 && owner.getPreferredMeetingDurations().isDoubleLength() && request.getSelectedDuration() == owner.getPreferredMeetingDurations().getMaxLength()) {
            block = this.availableScheduleDao.retrieveTargetDoubleLengthBlock(owner, XMLDataUtils.convertXMLGregorianCalendarToDate((XMLGregorianCalendar)request.getStartTime()));
        }
        if (null == block) {
            throw new SchedulingException("requested time is not available");
        }
        VEvent event = this.schedulingAssistantService.scheduleAppointment(visitor, owner, block, request.getEventDescription());
        CreateAppointmentResponse response = new CreateAppointmentResponse();
        response.setStartTime(XMLDataUtils.convertDateToXMLGregorianCalendar((Date)event.getStartDate().getDate()));
        response.setEndTime(XMLDataUtils.convertDateToXMLGregorianCalendar((Date)event.getEndDate().getDate()));
        response.setEventLocation(event.getLocation().getValue());
        response.setEventTitle(event.getSummary().getValue());
        return response;
    }

    @PayloadRoot(localPart="CancelAppointmentRequest", namespace="https://source.jasig.org/schemas/sched-assist")
    public CancelAppointmentResponse cancelAppointment(CancelAppointmentRequest request) throws NotAVisitorException, InputFormatException, SchedulingException, CalendarAccountNotFoundException, NotRegisteredException {
        AvailableBlock targetBlock;
        ICalendarAccount visitorCalendarUser = this.calendarAccountDao.getCalendarAccount(request.getVisitorNetid());
        IScheduleVisitor visitor = this.visitorDao.toVisitor(visitorCalendarUser);
        IScheduleOwner owner = this.ownerDao.locateOwnerByAvailableId(request.getOwnerId());
        if (null == owner) {
            throw new NotRegisteredException(request.getOwnerId() + " not currently registered as a schedule owner");
        }
        if (null == request.getStartTime() || null == request.getEndTime()) {
            throw new InputFormatException("start and/or end time not properly set");
        }
        Date startTime = XMLDataUtils.convertXMLGregorianCalendarToDate((XMLGregorianCalendar)request.getStartTime());
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("start time: " + startTime));
        }
        Date endTime = XMLDataUtils.convertXMLGregorianCalendarToDate((XMLGregorianCalendar)request.getEndTime());
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("end time: " + endTime));
        }
        if (null == (targetBlock = this.availableScheduleDao.retrieveTargetBlock(owner, startTime))) {
            throw new SchedulingException("requested time is not available in schedule");
        }
        if (!(targetBlock.getEndTime().equals(endTime) || null != (targetBlock = this.availableScheduleDao.retrieveTargetDoubleLengthBlock(owner, startTime)) && targetBlock.getEndTime().equals(endTime))) {
            throw new SchedulingException("requested time is not available in schedule");
        }
        VEvent existingEvent = this.schedulingAssistantService.getExistingAppointment(targetBlock, owner);
        this.schedulingAssistantService.cancelAppointment(visitor, owner, existingEvent, targetBlock, request.getReason());
        CancelAppointmentResponse response = new CancelAppointmentResponse();
        response.setStartTime(XMLDataUtils.convertDateToXMLGregorianCalendar((Date)targetBlock.getStartTime()));
        response.setEndTime(XMLDataUtils.convertDateToXMLGregorianCalendar((Date)targetBlock.getEndTime()));
        return response;
    }

    @PayloadRoot(localPart="GetRelationshipsRequest", namespace="https://source.jasig.org/schemas/sched-assist")
    public GetRelationshipsResponse getRelationships(GetRelationshipsRequest request) throws NotAVisitorException, CalendarAccountNotFoundException {
        ICalendarAccount visitorCalendarUser = this.calendarAccountDao.getCalendarAccount(request.getVisitorNetid());
        IScheduleVisitor visitor = this.visitorDao.toVisitor(visitorCalendarUser);
        List relationships = this.relationshipDao.forVisitor(visitor);
        ArrayList<RelationshipElement> elements = new ArrayList<RelationshipElement>();
        for (Relationship relationship : relationships) {
            IScheduleOwner owner = relationship.getOwner();
            ScheduleOwnerElement ownerElement = SOAPSchedulingAssistantServiceEndpoint.createScheduleOwnerElement((IScheduleOwner)owner);
            RelationshipElement element = new RelationshipElement();
            element.setDescription(relationship.getDescription());
            element.setScheduleOwnerElement(ownerElement);
            elements.add(element);
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("visitor: " + visitor + ", relationships: " + relationships));
        }
        RelationshipList relationshipList = new RelationshipList();
        relationshipList.getRelationshipElement().addAll(elements);
        GetRelationshipsResponse response = new GetRelationshipsResponse();
        response.setRelationshipList(relationshipList);
        return response;
    }

    @PayloadRoot(localPart="GetScheduleOwnerByIdRequest", namespace="https://source.jasig.org/schemas/sched-assist")
    public GetScheduleOwnerByIdResponse getScheduleOwnerById(GetScheduleOwnerByIdRequest request) throws CalendarAccountNotFoundException, NotRegisteredException {
        IScheduleOwner owner = this.ownerDao.locateOwnerByAvailableId(request.getId());
        GetScheduleOwnerByIdResponse response = new GetScheduleOwnerByIdResponse();
        if (null != owner) {
            ScheduleOwnerElement element = SOAPSchedulingAssistantServiceEndpoint.createScheduleOwnerElement((IScheduleOwner)owner);
            response.setScheduleOwnerElement(element);
            return response;
        }
        throw new NotRegisteredException("no registered ScheduleOwner found for available id: " + request.getId());
    }

    @PayloadRoot(localPart="VisitorConflictsRequest", namespace="https://source.jasig.org/schemas/sched-assist")
    public VisitorConflictsResponse getVisitorConflicts(VisitorConflictsRequest request) throws NotAVisitorException, NotRegisteredException {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)request);
        }
        ICalendarAccount visitorCalendarUser = this.calendarAccountDao.getCalendarAccount(request.getVisitorNetid());
        IScheduleVisitor visitor = this.visitorDao.toVisitor(visitorCalendarUser);
        IScheduleOwner owner = this.ownerDao.locateOwnerByAvailableId(request.getOwnerId());
        if (null == owner) {
            throw new NotRegisteredException(request.getOwnerId() + " not currently registered as a schedule owner");
        }
        VisibleScheduleRequestConstraints requestConstraints = VisibleScheduleRequestConstraints.newInstance((IScheduleOwner)owner, (int)request.getWeekStart());
        List conflicts = this.schedulingAssistantService.calculateVisitorConflicts(visitor, owner, requestConstraints.getTargetStartDate(), requestConstraints.getTargetEndDate());
        ArrayList<AvailableBlockElement> blockElementList = new ArrayList<AvailableBlockElement>();
        for (AvailableBlock conflict : conflicts) {
            AvailableBlockElement element = this.createAvailableBlockElement(conflict);
            element.setStatus(AvailableStatusType.BUSY);
            blockElementList.add(element);
        }
        AvailableBlockList listWrapper = new AvailableBlockList();
        listWrapper.getAvailableBlockElement().addAll(blockElementList);
        VisitorConflictsResponse response = new VisitorConflictsResponse();
        response.setAvailableBlockList(listWrapper);
        return response;
    }

    protected AvailableBlockElement createAvailableBlockElement(AvailableBlock block) {
        if (null == block) {
            return null;
        }
        AvailableBlockElement element = new AvailableBlockElement();
        element.setEndTime(XMLDataUtils.convertDateToXMLGregorianCalendar((Date)block.getEndTime()));
        element.setStartTime(XMLDataUtils.convertDateToXMLGregorianCalendar((Date)block.getStartTime()));
        element.setVisitorLimit(block.getVisitorLimit());
        element.setVisitorsAttending(block.getVisitorsAttending());
        return element;
    }

    protected static ScheduleOwnerElement createScheduleOwnerElement(IScheduleOwner owner) {
        ScheduleOwnerElement element = new ScheduleOwnerElement();
        element.setFullName(owner.getCalendarAccount().getDisplayName());
        element.setId(owner.getId());
        element.setNetid(owner.getCalendarAccount().getUsername());
        PreferencesSet prefSet = new PreferencesSet();
        element.setPreferencesSet(prefSet);
        Map ownerPreferences = owner.getPreferences();
        for (Map.Entry entry : ownerPreferences.entrySet()) {
            PreferencesElement prefElement = new PreferencesElement();
            prefElement.setKey(((Preferences)entry.getKey()).getKey());
            prefElement.setValue((String)entry.getValue());
            element.getPreferencesSet().getPreferencesElement().add(prefElement);
        }
        return element;
    }
}

