/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.visitor;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import net.fortuna.ical4j.model.component.VEvent;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.RelationshipDao;
import org.jasig.schedassist.SchedulingAssistantService;
import org.jasig.schedassist.SchedulingException;
import org.jasig.schedassist.impl.owner.AvailableScheduleDao;
import org.jasig.schedassist.impl.owner.OwnerDao;
import org.jasig.schedassist.impl.owner.PublicProfileDao;
import org.jasig.schedassist.impl.visitor.NotAVisitorException;
import org.jasig.schedassist.model.AvailableBlock;
import org.jasig.schedassist.model.CommonDateOperations;
import org.jasig.schedassist.model.IEventUtils;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.IScheduleVisitor;
import org.jasig.schedassist.model.InputFormatException;
import org.jasig.schedassist.model.PublicProfile;
import org.jasig.schedassist.model.Relationship;
import org.jasig.schedassist.model.VisibleSchedule;
import org.jasig.schedassist.web.security.CalendarAccountUserDetailsImpl;
import org.jasig.schedassist.web.visitor.CreateAppointmentFormBackingObject;
import org.jasig.schedassist.web.visitor.CreateAppointmentFormBackingObjectValidator;
import org.jasig.schedassist.web.visitor.OwnerNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;

@Controller
@RequestMapping(value={"/schedule/{ownerIdentifier}/create.html"})
@SessionAttributes(value={"command"})
public class CreateAppointmentFormController {
    private static final String COMMAND_ATTR_NAME = "command";
    private Log LOG = LogFactory.getLog(this.getClass());
    private SchedulingAssistantService schedulingAssistantService;
    private RelationshipDao relationshipDao;
    private AvailableScheduleDao availableScheduleDao;
    private OwnerDao ownerDao;
    private PublicProfileDao publicProfileDao;
    private IEventUtils eventUtils;

    @Autowired
    public void setAvailableService(SchedulingAssistantService schedulingAssistantService) {
        this.schedulingAssistantService = schedulingAssistantService;
    }

    @Autowired
    public void setRelationshipDao(@Qualifier(value="composite") RelationshipDao relationshipDao) {
        this.relationshipDao = relationshipDao;
    }

    @Autowired
    public void setAvailableScheduleDao(AvailableScheduleDao availableScheduleDao) {
        this.availableScheduleDao = availableScheduleDao;
    }

    @Autowired
    public void setOwnerDao(OwnerDao ownerDao) {
        this.ownerDao = ownerDao;
    }

    @Autowired
    public void setPublicProfileDao(PublicProfileDao publicProfileDao) {
        this.publicProfileDao = publicProfileDao;
    }

    @Autowired
    public void setEventUtils(IEventUtils eventUtils) {
        this.eventUtils = eventUtils;
    }

    @InitBinder(value={"command"})
    protected void initBinder(WebDataBinder binder) {
        binder.setValidator((Validator)new CreateAppointmentFormBackingObjectValidator());
    }

    @RequestMapping(method={RequestMethod.GET})
    protected String setupForm(ModelMap model, @RequestParam(value="startTime", required=true) String startTimePhrase, @PathVariable(value="ownerIdentifier") String ownerIdentifier) throws InputFormatException, SchedulingException, OwnerNotFoundException, NotAVisitorException {
        VisibleSchedule sched;
        int attendingCount;
        CalendarAccountUserDetailsImpl currentUser = (CalendarAccountUserDetailsImpl)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        IScheduleVisitor visitor = currentUser.getScheduleVisitor();
        IScheduleOwner selectedOwner = null;
        if (StringUtils.isNumeric((String)ownerIdentifier)) {
            Long ownerId = Long.parseLong(ownerIdentifier);
            selectedOwner = this.findOwnerForVisitor(visitor, ownerId.longValue());
        } else {
            PublicProfile profile = this.publicProfileDao.locatePublicProfileByKey(ownerIdentifier);
            if (null != profile) {
                selectedOwner = this.ownerDao.locateOwnerByAvailableId(profile.getOwnerId());
            }
        }
        if (null == selectedOwner) {
            throw new OwnerNotFoundException("no owner found for " + ownerIdentifier);
        }
        model.put((Object)"owner", (Object)selectedOwner);
        if (selectedOwner.hasMeetingLimit() && selectedOwner.isExceedingMeetingLimit(attendingCount = (sched = this.schedulingAssistantService.getVisibleSchedule(visitor, selectedOwner)).getAttendingCount())) {
            this.LOG.warn((Object)("blocked attempt to use create form by visitor: " + visitor + ", target owner: " + selectedOwner));
            return "redirect:view.html";
        }
        Date startTime = CommonDateOperations.parseDateTimePhrase((String)startTimePhrase);
        AvailableBlock targetBlock = this.availableScheduleDao.retrieveTargetBlock(selectedOwner, startTime);
        if (null == targetBlock) {
            throw new SchedulingException("requested time is not available");
        }
        VEvent event = this.schedulingAssistantService.getExistingAppointment(targetBlock, selectedOwner);
        if (event != null) {
            model.put((Object)"event", (Object)event);
            if (this.eventUtils.isAttendingAsVisitor(event, visitor.getCalendarAccount())) {
                StringBuilder redirect = new StringBuilder("redirect:cancel.html?r=true&startTime=");
                SimpleDateFormat dateFormat = CommonDateOperations.getDateTimeFormat();
                redirect.append(startTimePhrase);
                redirect.append("&endTime=");
                redirect.append(dateFormat.format(targetBlock.getEndTime()));
                return redirect.toString();
            }
            Integer visitorLimit = this.eventUtils.getEventVisitorLimit(event);
            model.put((Object)"visitorLimit", (Object)visitorLimit);
            if (this.eventUtils.getScheduleVisitorCount(event) >= visitorLimit) {
                return "visitor/appointment-full";
            }
        }
        CreateAppointmentFormBackingObject fbo = new CreateAppointmentFormBackingObject(targetBlock, selectedOwner.getPreferredMeetingDurations());
        model.addAttribute(COMMAND_ATTR_NAME, (Object)fbo);
        return "visitor/create-appointment-form";
    }

    @RequestMapping(method={RequestMethod.POST})
    protected String createAppointment(ModelMap model, @PathVariable(value="ownerIdentifier") String ownerIdentifier, @Valid @ModelAttribute(value="command") CreateAppointmentFormBackingObject fbo, BindingResult bindingResult) throws NotAVisitorException, OwnerNotFoundException, SchedulingException {
        CalendarAccountUserDetailsImpl currentUser = (CalendarAccountUserDetailsImpl)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        IScheduleVisitor visitor = currentUser.getScheduleVisitor();
        if (bindingResult.hasErrors()) {
            return "visitor/create-appointment-form";
        }
        IScheduleOwner selectedOwner = null;
        if (StringUtils.isNumeric((String)ownerIdentifier)) {
            Long ownerId = Long.parseLong(ownerIdentifier);
            selectedOwner = this.findOwnerForVisitor(visitor, ownerId.longValue());
        } else {
            PublicProfile profile = this.publicProfileDao.locatePublicProfileByKey(ownerIdentifier);
            if (null != profile) {
                selectedOwner = this.ownerDao.locateOwnerByAvailableId(profile.getOwnerId());
            }
        }
        if (null == selectedOwner) {
            throw new OwnerNotFoundException("no owner found for " + ownerIdentifier);
        }
        AvailableBlock finalAppointmentBlock = fbo.getTargetBlock();
        if (fbo.isDoubleLengthAvailable() && fbo.getSelectedDuration() == fbo.getMeetingDurations().getMaxLength()) {
            finalAppointmentBlock = this.availableScheduleDao.retrieveTargetDoubleLengthBlock(selectedOwner, finalAppointmentBlock.getStartTime());
        }
        if (null == finalAppointmentBlock) {
            throw new SchedulingException("requested time is not available");
        }
        VEvent event = this.schedulingAssistantService.scheduleAppointment(visitor, selectedOwner, finalAppointmentBlock, fbo.getReason());
        model.put((Object)"event", (Object)event);
        model.put((Object)"owner", (Object)selectedOwner);
        model.put((Object)"ownerRemindersPreference", (Object)selectedOwner.getRemindersPreference());
        return "visitor/create-appointment-success";
    }

    private IScheduleOwner findOwnerForVisitor(IScheduleVisitor visitor, long ownerId) throws OwnerNotFoundException {
        List relationships = this.relationshipDao.forVisitor(visitor);
        for (Relationship potential : relationships) {
            if (potential.getOwner().getId() != ownerId) continue;
            return potential.getOwner();
        }
        throw new OwnerNotFoundException("owner id " + ownerId + " not found");
    }
}

