/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.visitor;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.RelationshipDao;
import org.jasig.schedassist.SchedulingAssistantService;
import org.jasig.schedassist.impl.owner.OwnerDao;
import org.jasig.schedassist.impl.owner.PublicProfileDao;
import org.jasig.schedassist.impl.visitor.NotAVisitorException;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.IScheduleVisitor;
import org.jasig.schedassist.model.Preferences;
import org.jasig.schedassist.model.PublicProfile;
import org.jasig.schedassist.model.Relationship;
import org.jasig.schedassist.model.VisibleSchedule;
import org.jasig.schedassist.model.VisibleScheduleRequestConstraints;
import org.jasig.schedassist.web.security.CalendarAccountUserDetailsImpl;
import org.jasig.schedassist.web.visitor.OwnerNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VisibleScheduleDisplayController {
    private Log LOG = LogFactory.getLog(this.getClass());
    private SchedulingAssistantService schedulingAssistantService;
    private RelationshipDao relationshipDao;
    private OwnerDao ownerDao;
    private PublicProfileDao publicProfileDao;

    @Autowired
    public void setAvailableService(SchedulingAssistantService schedulingAssistantService) {
        this.schedulingAssistantService = schedulingAssistantService;
    }

    @Autowired
    public void setRelationshipDao(@Qualifier(value="composite") RelationshipDao relationshipDao) {
        this.relationshipDao = relationshipDao;
    }

    @Autowired
    public void setOwnerDao(OwnerDao ownerDao) {
        this.ownerDao = ownerDao;
    }

    @Autowired
    public void setPublicProfileDao(PublicProfileDao publicProfileDao) {
        this.publicProfileDao = publicProfileDao;
    }

    @RequestMapping(value={"/schedule/{ownerIdentifier}/view.html"}, method={RequestMethod.GET})
    public ModelAndView displaySchedule(@PathVariable(value="ownerIdentifier") String ownerIdentifier, @RequestParam(value="highContrast", required=false, defaultValue="false") boolean highContrast, @RequestParam(value="weekStart", required=false, defaultValue="0") int weekStart) throws NotAVisitorException, OwnerNotFoundException {
        VisibleSchedule schedule;
        CalendarAccountUserDetailsImpl currentUser = (CalendarAccountUserDetailsImpl)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        IScheduleVisitor visitor = currentUser.getScheduleVisitor();
        IScheduleOwner selectedOwner = this.locateOwnerFromIdentifier(ownerIdentifier, visitor);
        VisibleScheduleRequestConstraints requestConstraints = VisibleScheduleRequestConstraints.newInstance((IScheduleOwner)selectedOwner, (int)weekStart);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("displaySchedule request, currentUser: " + currentUser + "; weekStart: " + weekStart + "requestConstraints " + requestConstraints));
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        String noteboard = selectedOwner.getPreference(Preferences.NOTEBOARD);
        String[] noteboardSentences = noteboard.split("\n");
        model.put("noteboardSentences", noteboardSentences);
        model.put("owner", selectedOwner);
        model.put("highContrast", highContrast);
        if (selectedOwner.hasMeetingLimit()) {
            schedule = this.schedulingAssistantService.getVisibleSchedule(visitor, selectedOwner);
            if (selectedOwner.isExceedingMeetingLimit(schedule.getAttendingCount())) {
                List attendingList = schedule.getAttendingList();
                model.put("attendingList", attendingList);
                return new ModelAndView("visitor/visitor-already-attending", model);
            }
            schedule = schedule.subset(requestConstraints.getTargetStartDate(), requestConstraints.getTargetEndDate());
        } else {
            schedule = this.schedulingAssistantService.getVisibleSchedule(visitor, selectedOwner, requestConstraints.getTargetStartDate(), requestConstraints.getTargetEndDate());
        }
        model.put("visibleSchedule", schedule);
        model.put("scheduleStart", schedule.getScheduleStart());
        model.put("prevWeekStart", requestConstraints.getPrevWeekIndex());
        model.put("nextWeekStart", requestConstraints.getNextWeekIndex());
        model.put("weekStart", requestConstraints.getConstrainedWeekStart());
        model.put("ownerVisitorSamePerson", selectedOwner.isSamePerson(visitor));
        return new ModelAndView("visitor/visitor-visible-schedule", model);
    }

    private IScheduleOwner locateOwnerFromIdentifier(String ownerIdentifier, IScheduleVisitor visitor) throws OwnerNotFoundException {
        IScheduleOwner selectedOwner = null;
        if (StringUtils.isNumeric((String)ownerIdentifier)) {
            Long ownerId = Long.parseLong(ownerIdentifier);
            selectedOwner = this.findOwnerForVisitor(visitor, ownerId.longValue());
        } else {
            PublicProfile profile = this.publicProfileDao.locatePublicProfileByKey(ownerIdentifier);
            if (null != profile) {
                selectedOwner = this.ownerDao.locateOwnerByAvailableId(profile.getOwnerId());
            }
        }
        if (null == selectedOwner) {
            throw new OwnerNotFoundException("no owner found for " + ownerIdentifier);
        }
        return selectedOwner;
    }

    private IScheduleOwner findOwnerForVisitor(IScheduleVisitor visitor, long ownerId) throws OwnerNotFoundException {
        List relationships = this.relationshipDao.forVisitor(visitor);
        for (Relationship potential : relationships) {
            if (potential.getOwner().getId() != ownerId) continue;
            return potential.getOwner();
        }
        throw new OwnerNotFoundException("owner id " + ownerId + " not found");
    }
}

