/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.profiles;

import java.util.List;
import org.jasig.schedassist.impl.owner.PublicProfileDao;
import org.jasig.schedassist.model.PublicProfile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class PublicProfileController {
    private PublicProfileDao publicProfileDao;

    @Autowired
    public void setPublicProfileDao(PublicProfileDao publicProfileDao) {
        this.publicProfileDao = publicProfileDao;
    }

    @RequestMapping(value={"/public/profiles/{profileKey}.html"}, method={RequestMethod.GET})
    public String retrieveProfile(ModelMap model, @PathVariable(value="profileKey") String profileKey) {
        PublicProfile profile = this.publicProfileDao.locatePublicProfileByKey(profileKey);
        if (null != profile) {
            model.addAttribute("profile", (Object)profile);
            List tags = this.publicProfileDao.getProfileTags(profile.getPublicProfileId());
            model.addAttribute("profileTags", (Object)tags);
            return "profiles/profile";
        }
        return "profiles/owner-notfound";
    }
}

