/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.owner.preferences;

import org.apache.commons.lang.StringUtils;
import org.jasig.schedassist.model.Reminders;
import org.jasig.schedassist.web.owner.preferences.PreferencesFormBackingObject;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class PreferencesFormBackingObjectValidator
implements Validator {
    private int noteboardMaxLength = 500;

    public boolean supports(Class<?> clazz) {
        return PreferencesFormBackingObject.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        PreferencesFormBackingObject fbo = (PreferencesFormBackingObject)target;
        if (StringUtils.isBlank((String)fbo.getLocation())) {
            errors.rejectValue("location", "location.required", "Location field must not be empty.");
        } else if (fbo.getLocation().length() > 100) {
            errors.rejectValue("location", "location.toolong", "Location field is too long (" + fbo.getLocation().length() + "); maximum length is 100 characters.");
        }
        if (StringUtils.isBlank((String)fbo.getTitlePrefix())) {
            errors.rejectValue("titlePrefix", "titlePrefix.required", "Meeting Title Prefix field must not be empty.");
        } else if (fbo.getTitlePrefix().length() > 100) {
            errors.rejectValue("titlePrefix", "titlePrefix.toolong", "Meeting Title Prefix field is too long (" + fbo.getTitlePrefix().length() + "); maximum length is 100 characters.");
        }
        if (StringUtils.isBlank((String)fbo.getMeetingLength())) {
            errors.rejectValue("meetingLength", "meetingLength.required", "Meeting Length field must not be empty.");
        } else {
            try {
                int meetingLength = Integer.parseInt(fbo.getMeetingLength());
                if (meetingLength < 15 || meetingLength > 240) {
                    errors.rejectValue("meetingLength", "meetingLength.outofbounds", "Meeting Length must be greater than 15 minutes and less than 240 minutes.");
                }
            }
            catch (NumberFormatException e) {
                errors.rejectValue("meetingLength", "meetingLength.invalid", "Invalid value for meeting duration.");
            }
        }
        if (fbo.getDefaultVisitorsPerAppointment() < 1) {
            errors.rejectValue("defaultVisitorsPerAppointment", "defaultVisitors.toosmall", "Default visitors per appointment must be greater than or equal to 1.");
        }
        if (fbo.getDefaultVisitorsPerAppointment() > 99) {
            errors.rejectValue("defaultVisitorsPerAppointment", "defaultVisitors.toosmall", "Maximum allowed value for default visitors per appointment is 99.");
        }
        if (fbo.getWindowHoursStart() < 1) {
            errors.rejectValue("windowHoursStart", "windowhoursstart.toosmall", "Your visible window start must be at least 1 hour.");
        }
        if (fbo.getWindowHoursStart() >= 168) {
            errors.rejectValue("windowHoursStart", "windowhoursstart.toolarge", "Your visible window start must be less than 168 hours (1 week).");
        }
        if (fbo.getWindowWeeksEnd() < 1) {
            errors.rejectValue("windowWeeksEnd", "windowweeksend.toosmall", "Your visible window end must be at least 1 week.");
        }
        if (fbo.getWindowWeeksEnd() > 26) {
            errors.rejectValue("windowWeeksEnd", "windowweeksend.toosmall", "Your visible window end cannot be greater than 26 weeks.");
        }
        if (fbo.isEnableMeetingLimit()) {
            if (fbo.getMeetingLimitValue() < 1) {
                errors.rejectValue("meetingLimitValue", "meetinglimitvalue.toosmall", "Meeting Limit value must be greater than or equal to 1.");
            } else if (fbo.getMeetingLimitValue() > 10) {
                errors.rejectValue("meetingLimitValue", "meetinglimitvalue.toolarge", "Meeting Limit value greater than 10 is not much of a limit; you should just disable meeting limits.");
            }
        } else {
            fbo.setMeetingLimitValue(-1);
        }
        if (StringUtils.isBlank((String)fbo.getNoteboard())) {
            errors.rejectValue("noteboard", "noteboard.required", "Noteboard field is required.");
        } else {
            String noteboardNoControlM = fbo.getNoteboard().replaceAll("\\r", "");
            fbo.setNoteboard(noteboardNoControlM);
            if (null != fbo.getNoteboard() && fbo.getNoteboard().length() > this.noteboardMaxLength) {
                errors.rejectValue("noteboard", "noteboard.toolarge", "Noteboard is too long (" + fbo.getNoteboard().length() + " characters); maximum length is " + this.noteboardMaxLength + " characters.");
            }
        }
        if (fbo.isEnableEmailReminders()) {
            if (fbo.getEmailReminderHours() < 1 || fbo.getEmailReminderHours() > 99) {
                errors.rejectValue("emailReminderHours", "emailReminderHours.outofbounds", "Email reminder hours must be between 1 and 99.");
            }
        } else {
            fbo.setEmailReminderHours(Reminders.DEFAULT.getHours());
            fbo.setEmailReminderIncludeOwner(Reminders.DEFAULT.isIncludeOwner());
        }
    }
}

