/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.owner.relationships;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jasig.schedassist.ICalendarAccountDao;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.web.owner.relationships.CalendarUserSearchFormBackingObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;

@Controller
@RequestMapping(value={"/owner/visitor-search.html", "/delegate/visitor-search.html"})
@SessionAttributes(value={"command"})
public class CalendarUserSearchFormController {
    private ICalendarAccountDao calendarAccountDao;

    @Autowired
    public void setCalendarAccountDao(ICalendarAccountDao calendarAccountDao) {
        this.calendarAccountDao = calendarAccountDao;
    }

    @RequestMapping(method={RequestMethod.GET})
    protected String onGet(@RequestParam(value="q", required=false) String qValue, ModelMap model) {
        if (StringUtils.isBlank((String)qValue)) {
            CalendarUserSearchFormBackingObject fbo = new CalendarUserSearchFormBackingObject();
            model.addAttribute("command", (Object)fbo);
            return "owner-relationships/calendaruser-search-form";
        }
        model.addAttribute("searchText", (Object)qValue);
        List<Object> matches = new ArrayList<ICalendarAccount>();
        if (null != qValue && qValue.length() > 2) {
            String searchText = StringUtils.replace((String)qValue, (String)" ", (String)"*");
            matches = this.calendarAccountDao.searchForCalendarAccounts(searchText);
        }
        List<ICalendarAccount> results = this.filterForEligible(matches);
        model.addAttribute("results", results);
        return "owner-relationships/calendaruser-results-ac";
    }

    @RequestMapping(method={RequestMethod.POST})
    protected String search(@ModelAttribute(value="command") CalendarUserSearchFormBackingObject fbo, ModelMap model) {
        model.addAttribute("searchText", (Object)fbo.getSearchText());
        List<Object> matches = new ArrayList<ICalendarAccount>();
        if (fbo.getSearchText() != null && fbo.getSearchText().length() > 2) {
            String searchText = StringUtils.replace((String)fbo.getSearchText(), (String)" ", (String)"*");
            matches = this.calendarAccountDao.searchForCalendarAccounts(searchText);
        }
        List<ICalendarAccount> results = this.filterForEligible(matches);
        model.addAttribute("results", results);
        return "owner-relationships/calendaruser-results";
    }

    protected List<ICalendarAccount> filterForEligible(List<ICalendarAccount> matches) {
        ArrayList<ICalendarAccount> results = new ArrayList<ICalendarAccount>();
        for (ICalendarAccount a : matches) {
            if (!a.isEligible()) continue;
            results.add(a);
        }
        return results;
    }
}

