/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.profiles;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jasig.schedassist.impl.owner.PublicProfileDao;
import org.jasig.schedassist.model.PublicProfileId;
import org.jasig.schedassist.web.profiles.ProfilePageInformation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class PublicProfilesBrowseController {
    private PublicProfileDao publicProfileDao;

    @Autowired
    public void setPublicProfileDao(PublicProfileDao publicProfileDao) {
        this.publicProfileDao = publicProfileDao;
    }

    @RequestMapping(value={"/public/browse.html"}, method={RequestMethod.GET})
    public String retrieveAllProfiles(ModelMap model, @RequestParam(value="startIndex", required=false, defaultValue="0") int startIndex) {
        List profileIds = this.publicProfileDao.getPublicProfileIds();
        if (profileIds.isEmpty()) {
            model.addAttribute("titleSuffix", (Object)"");
            return "profiles/public-listing";
        }
        this.populateModel(model, profileIds, startIndex);
        return "profiles/public-listing";
    }

    @RequestMapping(value={"/public/advisors.html"}, method={RequestMethod.GET})
    public String retrieveAdvisorProfiles(ModelMap model, @RequestParam(value="startIndex", required=false, defaultValue="0") int startIndex) {
        List profileIds = this.publicProfileDao.getAdvisorPublicProfileIds();
        if (profileIds.isEmpty()) {
            model.addAttribute("titleSuffix", (Object)"");
            return "profiles/public-advisor-listing";
        }
        this.populateModel(model, profileIds, startIndex);
        return "profiles/public-advisor-listing";
    }

    @RequestMapping(value={"/public/instructors.html"}, method={RequestMethod.GET})
    public String retrieveInstructorProfiles(ModelMap model, @RequestParam(value="startIndex", required=false, defaultValue="0") int startIndex) {
        List profileIds = this.publicProfileDao.getInstructorPublicProfileIds();
        if (profileIds.isEmpty()) {
            model.addAttribute("titleSuffix", (Object)"");
            return "profiles/public-instructor-listing";
        }
        this.populateModel(model, profileIds, startIndex);
        return "profiles/public-instructor-listing";
    }

    protected void populateModel(ModelMap model, List<PublicProfileId> profileIds, int startIndex) {
        Collections.sort(profileIds);
        ProfilePageInformation pageInfo = new ProfilePageInformation(profileIds, startIndex);
        List<PublicProfileId> sublist = pageInfo.getSublist();
        Map profileMap = this.publicProfileDao.getProfileTagsBatch(sublist);
        model.addAttribute("titleSuffix", (Object)this.buildPageTitleSuffix(pageInfo.getStartIndex(), pageInfo.getEndIndex()));
        model.addAttribute("profileIds", sublist);
        model.addAttribute("profileMap", (Object)profileMap);
        model.addAttribute("showPrev", (Object)pageInfo.isShowPrev());
        model.addAttribute("showPrevIndex", (Object)pageInfo.getShowPrevIndex());
        model.addAttribute("showNext", (Object)pageInfo.isShowNext());
        model.addAttribute("showNextIndex", (Object)pageInfo.getShowNextIndex());
    }

    protected String buildPageTitleSuffix(int startIndex, int endIndex) {
        StringBuilder title = new StringBuilder();
        title.append(" ");
        title.append(startIndex == 0 ? 1 : startIndex + 1);
        title.append(" - ");
        title.append(endIndex);
        return title.toString();
    }
}

