/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.register.delegate;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import java.util.SortedSet;
import org.apache.commons.lang.StringUtils;
import org.jasig.schedassist.impl.AvailableScheduleReflectionService;
import org.jasig.schedassist.impl.owner.AvailableScheduleDao;
import org.jasig.schedassist.impl.owner.IneligibleException;
import org.jasig.schedassist.impl.owner.OwnerDao;
import org.jasig.schedassist.model.AvailableBlockBuilder;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.InputFormatException;
import org.jasig.schedassist.model.Preferences;
import org.jasig.schedassist.web.register.Registration;
import org.jasig.schedassist.web.security.DelegateCalendarAccountUserDetailsImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service(value="delegateRegistrationHelper")
public class DelegateRegistrationHelper {
    private AvailableScheduleDao availableScheduleDao;
    private OwnerDao ownerDao;
    private AvailableScheduleReflectionService reflectionService;

    @Autowired
    public void setAvailableScheduleDao(AvailableScheduleDao availableScheduleDao) {
        this.availableScheduleDao = availableScheduleDao;
    }

    @Autowired
    public void setOwnerDao(OwnerDao ownerDao) {
        this.ownerDao = ownerDao;
    }

    @Autowired
    public void setReflectionService(AvailableScheduleReflectionService reflectionService) {
        this.reflectionService = reflectionService;
    }

    public void executeDelegateRegistration(Registration registration) throws IneligibleException, InputFormatException, ParseException {
        SecurityContext context = SecurityContextHolder.getContext();
        Authentication authentication = context.getAuthentication();
        DelegateCalendarAccountUserDetailsImpl currentUser = (DelegateCalendarAccountUserDetailsImpl)authentication.getPrincipal();
        IScheduleOwner delegateOwner = this.ownerDao.register(currentUser.getCalendarAccount());
        delegateOwner = this.ownerDao.updatePreference(delegateOwner, Preferences.LOCATION, registration.getLocation());
        delegateOwner = this.ownerDao.updatePreference(delegateOwner, Preferences.DURATIONS, registration.durationPreferenceValue());
        delegateOwner = this.ownerDao.updatePreference(delegateOwner, Preferences.MEETING_PREFIX, registration.getTitlePrefix());
        delegateOwner = this.ownerDao.updatePreference(delegateOwner, Preferences.NOTEBOARD, registration.getNoteboard());
        delegateOwner = this.ownerDao.updatePreference(delegateOwner, Preferences.VISIBLE_WINDOW, registration.visibleWindowPreferenceKey());
        delegateOwner = this.ownerDao.updatePreference(delegateOwner, Preferences.DEFAULT_VISITOR_LIMIT, Integer.toString(registration.getDefaultVisitorsPerAppointment()));
        delegateOwner = this.ownerDao.updatePreference(delegateOwner, Preferences.MEETING_LIMIT, Integer.toString(registration.getMeetingLimitValue()));
        delegateOwner = this.ownerDao.updatePreference(delegateOwner, Preferences.REFLECT_SCHEDULE, Boolean.toString(registration.isReflectSchedule()));
        delegateOwner = this.ownerDao.updatePreference(delegateOwner, Preferences.REMINDERS, registration.emailReminderPreferenceKey());
        if (registration.isScheduleSet()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
            SortedSet blocks = AvailableBlockBuilder.createBlocks((String)registration.getStartTimePhrase(), (String)registration.getEndTimePhrase(), (String)registration.getDaysOfWeekPhrase(), (Date)dateFormat.parse(registration.getStartDatePhrase()), (Date)dateFormat.parse(registration.getEndDatePhrase()), (int)registration.getDefaultVisitorsPerAppointment());
            this.availableScheduleDao.addToSchedule(delegateOwner, (Set)blocks);
        }
        if (registration.isReflectSchedule()) {
            this.reflectionService.reflectAvailableSchedule(delegateOwner);
        }
    }

    public String currentDelegateUsername() {
        SecurityContext context = SecurityContextHolder.getContext();
        Authentication authentication = context.getAuthentication();
        DelegateCalendarAccountUserDetailsImpl currentUser = (DelegateCalendarAccountUserDetailsImpl)authentication.getPrincipal();
        return currentUser.getUsername();
    }

    public String currentDelegateLocation() {
        SecurityContext context = SecurityContextHolder.getContext();
        Authentication authentication = context.getAuthentication();
        DelegateCalendarAccountUserDetailsImpl currentUser = (DelegateCalendarAccountUserDetailsImpl)authentication.getPrincipal();
        String accountLocation = currentUser.getDelegateCalendarAccount().getLocation();
        if (StringUtils.isNotBlank((String)accountLocation)) {
            return accountLocation;
        }
        return Preferences.LOCATION.getDefaultValue();
    }

    public boolean currentDelegateIsIneligible() {
        SecurityContext context = SecurityContextHolder.getContext();
        Authentication authentication = context.getAuthentication();
        DelegateCalendarAccountUserDetailsImpl currentUser = (DelegateCalendarAccountUserDetailsImpl)authentication.getPrincipal();
        boolean result = !currentUser.isEnabled();
        return result;
    }
}

