/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.security;

import java.io.IOException;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.schedassist.web.security.SecurityConstants;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;

public final class DelegateAuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    private String delegateOwnerTarget;
    private String delegateRegisterTarget;
    private String logoutTarget;
    private RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();

    public void setDelegateOwnerTarget(String delegateOwnerTarget) {
        this.delegateOwnerTarget = delegateOwnerTarget;
    }

    public void setDelegateRegisterTarget(String delegateRegisterTarget) {
        this.delegateRegisterTarget = delegateRegisterTarget;
    }

    public void setLogoutTarget(String logoutTarget) {
        this.logoutTarget = logoutTarget;
    }

    public void setRedirectStrategy(RedirectStrategy redirectStrategy) {
        this.redirectStrategy = redirectStrategy;
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        Collection authorities = authentication.getAuthorities();
        if (authorities.contains(SecurityConstants.DELEGATE_OWNER)) {
            this.redirectStrategy.sendRedirect(request, response, this.delegateOwnerTarget);
        } else if (authorities.contains(SecurityConstants.DELEGATE_REGISTER)) {
            this.redirectStrategy.sendRedirect(request, response, this.delegateRegisterTarget);
        } else {
            this.redirectStrategy.sendRedirect(request, response, this.logoutTarget);
        }
    }
}

