/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.admin;

import org.apache.commons.lang.StringUtils;
import org.jasig.schedassist.IAffiliationSource;
import org.jasig.schedassist.ICalendarAccountDao;
import org.jasig.schedassist.IDelegateCalendarAccountDao;
import org.jasig.schedassist.impl.ldap.HasDistinguishedName;
import org.jasig.schedassist.impl.owner.OwnerDao;
import org.jasig.schedassist.impl.owner.PublicProfileDao;
import org.jasig.schedassist.impl.visitor.NotAVisitorException;
import org.jasig.schedassist.impl.visitor.VisitorDao;
import org.jasig.schedassist.model.AffiliationImpl;
import org.jasig.schedassist.model.IAffiliation;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.IDelegateCalendarAccount;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.PublicProfile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/admin/account-details.html"})
public class AccountDetailsController {
    private ICalendarAccountDao calendarAccountDao;
    private IDelegateCalendarAccountDao delegateCalendarAccountDao;
    private VisitorDao visitorDao;
    private OwnerDao ownerDao;
    private PublicProfileDao publicProfileDao;
    private IAffiliationSource affiliationSource;

    @Autowired
    public void setCalendarAccountDao(@Qualifier(value="composite") ICalendarAccountDao calendarAccountDao) {
        this.calendarAccountDao = calendarAccountDao;
    }

    @Autowired
    public void setDelegateCalendarAccountDao(IDelegateCalendarAccountDao delegateCalendarAccountDao) {
        this.delegateCalendarAccountDao = delegateCalendarAccountDao;
    }

    @Autowired
    public void setVisitorDao(VisitorDao visitorDao) {
        this.visitorDao = visitorDao;
    }

    @Autowired
    public void setOwnerDao(OwnerDao ownerDao) {
        this.ownerDao = ownerDao;
    }

    @Autowired
    public void setPublicProfileDao(PublicProfileDao publicProfileDao) {
        this.publicProfileDao = publicProfileDao;
    }

    @Autowired
    public void setAffiliationSource(IAffiliationSource affiliationSource) {
        this.affiliationSource = affiliationSource;
    }

    @RequestMapping(method={RequestMethod.GET})
    protected String showDetails(@RequestParam(value="id", required=false, defaultValue="") String uniqueId, ModelMap model) {
        ICalendarAccount account;
        model.addAttribute("id", (Object)uniqueId);
        if (StringUtils.isNotBlank((String)uniqueId) && null != (account = this.calendarAccountDao.getCalendarAccountFromUniqueId(uniqueId))) {
            model.addAttribute("isDelegate", (Object)(account instanceof IDelegateCalendarAccount));
            model.addAttribute("calendarAccount", (Object)account);
            model.addAttribute("isAdvisor", (Object)this.affiliationSource.doesAccountHaveAffiliation(account, (IAffiliation)AffiliationImpl.ADVISOR));
            model.addAttribute("isInstructor", (Object)this.affiliationSource.doesAccountHaveAffiliation(account, (IAffiliation)AffiliationImpl.INSTRUCTOR));
            model.addAttribute("calendarAccountAttributes", account.getAttributes().entrySet());
            if (account instanceof HasDistinguishedName) {
                model.addAttribute("hasDistinguishedName", (Object)"true");
            }
            try {
                this.visitorDao.toVisitor(account);
                model.addAttribute("isVisitor", (Object)true);
            }
            catch (NotAVisitorException e) {
                // empty catch block
            }
            IScheduleOwner owner = this.ownerDao.locateOwner(account);
            if (null != owner) {
                model.addAttribute("owner", (Object)owner);
                model.addAttribute("ownerPreferences", owner.getPreferences().entrySet());
                PublicProfile profile = this.publicProfileDao.locatePublicProfileByOwner(owner);
                if (null != profile) {
                    model.addAttribute("publicProfile", (Object)profile);
                }
            }
        }
        return "admin/account-details";
    }

    @RequestMapping(method={RequestMethod.GET}, params={"resource"})
    protected String showDetailsResource(@RequestParam(value="id", required=false, defaultValue="") String uniqueId, ModelMap model) {
        IDelegateCalendarAccount account;
        model.addAttribute("id", (Object)uniqueId);
        if (StringUtils.isNotBlank((String)uniqueId) && null != (account = this.delegateCalendarAccountDao.getDelegateByUniqueId(uniqueId))) {
            model.addAttribute("isDelegate", (Object)true);
            model.addAttribute("calendarAccount", (Object)account);
            model.addAttribute("isAdvisor", (Object)this.affiliationSource.doesAccountHaveAffiliation((ICalendarAccount)account, (IAffiliation)AffiliationImpl.ADVISOR));
            model.addAttribute("isInstructor", (Object)this.affiliationSource.doesAccountHaveAffiliation((ICalendarAccount)account, (IAffiliation)AffiliationImpl.INSTRUCTOR));
            model.addAttribute("calendarAccountAttributes", account.getAttributes().entrySet());
            try {
                this.visitorDao.toVisitor((ICalendarAccount)account);
                model.addAttribute("isVisitor", (Object)true);
            }
            catch (NotAVisitorException e) {
                // empty catch block
            }
            IScheduleOwner owner = this.ownerDao.locateOwner((ICalendarAccount)account);
            if (null != owner) {
                model.addAttribute("owner", (Object)owner);
                model.addAttribute("ownerPreferences", owner.getPreferences().entrySet());
                PublicProfile profile = this.publicProfileDao.locatePublicProfileByOwner(owner);
                if (null != profile) {
                    model.addAttribute("publicProfile", (Object)profile);
                }
            }
        }
        return "admin/account-details";
    }
}

