/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.owner.preferences;

import javax.validation.Valid;
import org.jasig.schedassist.impl.AvailableScheduleReflectionService;
import org.jasig.schedassist.impl.owner.AvailableScheduleDao;
import org.jasig.schedassist.impl.owner.NotRegisteredException;
import org.jasig.schedassist.impl.owner.OwnerDao;
import org.jasig.schedassist.model.AvailableSchedule;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.MeetingDurations;
import org.jasig.schedassist.model.Preferences;
import org.jasig.schedassist.model.Reminders;
import org.jasig.schedassist.model.VisibleWindow;
import org.jasig.schedassist.web.owner.preferences.PreferencesFormBackingObject;
import org.jasig.schedassist.web.owner.preferences.PreferencesFormBackingObjectValidator;
import org.jasig.schedassist.web.security.CalendarAccountUserDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.SessionAttributes;

@Controller
@RequestMapping(value={"/owner/preferences.html", "/delegate/preferences.html"})
@SessionAttributes(value={"command"})
public class PreferencesFormController {
    private OwnerDao ownerDao;
    private AvailableScheduleDao availableScheduleDao;
    private AvailableScheduleReflectionService reflectionService;
    private PreferencesFormBackingObjectValidator validator;

    @Autowired
    public void setOwnerDao(OwnerDao ownerDao) {
        this.ownerDao = ownerDao;
    }

    @Autowired
    public void setReflectionService(AvailableScheduleReflectionService reflectionService) {
        this.reflectionService = reflectionService;
    }

    @Autowired
    public void setAvailableScheduleDao(AvailableScheduleDao availableScheduleDao) {
        this.availableScheduleDao = availableScheduleDao;
    }

    @Autowired
    public void setValidator(PreferencesFormBackingObjectValidator validator) {
        this.validator = validator;
    }

    @InitBinder(value={"command"})
    protected void initBinder(WebDataBinder binder) {
        binder.setValidator((Validator)this.validator);
    }

    @RequestMapping(method={RequestMethod.GET})
    protected String setupForm(ModelMap model) throws NotRegisteredException {
        CalendarAccountUserDetails currentUser = (CalendarAccountUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        IScheduleOwner owner = currentUser.getScheduleOwner();
        PreferencesFormBackingObject fbo = new PreferencesFormBackingObject();
        MeetingDurations meetingDurations = owner.getPreferredMeetingDurations();
        VisibleWindow visibleWindow = owner.getPreferredVisibleWindow();
        Reminders emailReminders = owner.getRemindersPreference();
        fbo.setMeetingLength(String.valueOf(meetingDurations.getMinLength()));
        fbo.setAllowDoubleLength(meetingDurations.isDoubleLength());
        fbo.setLocation(owner.getPreference(Preferences.LOCATION));
        fbo.setTitlePrefix(owner.getPreference(Preferences.MEETING_PREFIX));
        fbo.setNoteboard(owner.getPreference(Preferences.NOTEBOARD));
        fbo.setWindowHoursStart(visibleWindow.getWindowHoursStart());
        fbo.setWindowWeeksEnd(visibleWindow.getWindowWeeksEnd());
        fbo.setDefaultVisitorsPerAppointment(Integer.parseInt(owner.getPreference(Preferences.DEFAULT_VISITOR_LIMIT)));
        int currentMeetingLimitValue = Integer.parseInt(owner.getPreference(Preferences.MEETING_LIMIT));
        fbo.setMeetingLimitValue(currentMeetingLimitValue);
        fbo.setReflectSchedule(owner.isReflectSchedule());
        fbo.setEnableEmailReminders(emailReminders.isEnabled());
        fbo.setEmailReminderIncludeOwner(emailReminders.isIncludeOwner());
        fbo.setEmailReminderHours(emailReminders.getHours());
        model.addAttribute("command", (Object)fbo);
        return "owner-preferences/preferences-form";
    }

    @RequestMapping(method={RequestMethod.POST})
    protected String updatePreferences(@Valid @ModelAttribute(value="command") PreferencesFormBackingObject fbo, BindingResult bindingResult) throws NotRegisteredException {
        CalendarAccountUserDetails currentUser = (CalendarAccountUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        IScheduleOwner owner = currentUser.getScheduleOwner();
        if (bindingResult.hasErrors()) {
            return "owner-preferences/preferences-form";
        }
        if (!owner.getPreference(Preferences.DURATIONS).equals(fbo.durationPreferenceValue())) {
            owner = this.ownerDao.updatePreference(owner, Preferences.DURATIONS, fbo.durationPreferenceValue());
        }
        if (!owner.getPreference(Preferences.LOCATION).equals(fbo.getLocation())) {
            owner = this.ownerDao.updatePreference(owner, Preferences.LOCATION, fbo.getLocation());
        }
        if (!owner.getPreference(Preferences.MEETING_PREFIX).equals(fbo.getTitlePrefix())) {
            owner = this.ownerDao.updatePreference(owner, Preferences.MEETING_PREFIX, fbo.getTitlePrefix());
        }
        if (!owner.getPreference(Preferences.NOTEBOARD).equals(fbo.getNoteboard())) {
            owner = this.ownerDao.updatePreference(owner, Preferences.NOTEBOARD, fbo.getNoteboard());
        }
        if (!owner.getPreference(Preferences.VISIBLE_WINDOW).equals(fbo.visibleWindowPreferenceKey())) {
            owner = this.ownerDao.updatePreference(owner, Preferences.VISIBLE_WINDOW, fbo.visibleWindowPreferenceKey());
        }
        if (!owner.getPreference(Preferences.DEFAULT_VISITOR_LIMIT).equals(Integer.toString(fbo.getDefaultVisitorsPerAppointment()))) {
            owner = this.ownerDao.updatePreference(owner, Preferences.DEFAULT_VISITOR_LIMIT, Integer.toString(fbo.getDefaultVisitorsPerAppointment()));
        }
        if (!owner.getPreference(Preferences.MEETING_LIMIT).equals(Integer.toString(fbo.getMeetingLimitValue()))) {
            owner = this.ownerDao.updatePreference(owner, Preferences.MEETING_LIMIT, Integer.toString(fbo.getMeetingLimitValue()));
        }
        if (!owner.getPreference(Preferences.REMINDERS).equals(fbo.emailReminderPreferenceKey())) {
            owner = this.ownerDao.updatePreference(owner, Preferences.REMINDERS, fbo.emailReminderPreferenceKey());
        }
        if (owner.isReflectSchedule() != fbo.isReflectSchedule()) {
            owner = this.ownerDao.updatePreference(owner, Preferences.REFLECT_SCHEDULE, Boolean.toString(fbo.isReflectSchedule()));
            if (fbo.isReflectSchedule()) {
                this.reflectionService.reflectAvailableSchedule(owner);
            } else {
                AvailableSchedule schedule = this.availableScheduleDao.retrieve(owner);
                if (!schedule.isEmpty()) {
                    this.reflectionService.purgeReflections(owner, schedule.getScheduleStartTime(), schedule.getScheduleEndTime());
                }
            }
        }
        currentUser.updateScheduleOwner(owner);
        return "owner-preferences/preferences-success";
    }
}

