/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.owner.relationships;

import javax.validation.Valid;
import org.jasig.schedassist.CalendarAccountNotFoundException;
import org.jasig.schedassist.ICalendarAccountDao;
import org.jasig.schedassist.MutableRelationshipDao;
import org.jasig.schedassist.impl.owner.NotRegisteredException;
import org.jasig.schedassist.impl.visitor.NotAVisitorException;
import org.jasig.schedassist.impl.visitor.VisitorDao;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.IScheduleVisitor;
import org.jasig.schedassist.web.owner.relationships.ModifyAdhocRelationshipFormBackingObject;
import org.jasig.schedassist.web.owner.relationships.ModifyAdhocRelationshipFormBackingObjectValidator;
import org.jasig.schedassist.web.security.CalendarAccountUserDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;

@Controller
@RequestMapping(value={"/owner/create-adhoc-relationship.html", "/delegate/create-adhoc-relationship.html"})
@SessionAttributes(value={"command"})
public class CreateAdhocRelationshipFormController {
    private ICalendarAccountDao calendarAccountDao;
    private VisitorDao visitorDao;
    private MutableRelationshipDao mutableRelationshipDao;
    private String identifyingAttributeName = "uid";

    @Value(value="${users.visibleIdentifierAttributeName:uid}")
    public void setIdentifyingAttributeName(String identifyingAttributeName) {
        this.identifyingAttributeName = identifyingAttributeName;
    }

    public String getIdentifyingAttributeName() {
        return this.identifyingAttributeName;
    }

    @Autowired
    public void setCalendarAccountDao(ICalendarAccountDao calendarAccountDao) {
        this.calendarAccountDao = calendarAccountDao;
    }

    @Autowired
    public void setVisitorDao(VisitorDao visitorDao) {
        this.visitorDao = visitorDao;
    }

    @Autowired
    public void setMutableRelationshipDao(MutableRelationshipDao mutableRelationshipDao) {
        this.mutableRelationshipDao = mutableRelationshipDao;
    }

    @InitBinder(value={"command"})
    protected void initBinder(WebDataBinder binder) {
        binder.setValidator((Validator)new ModifyAdhocRelationshipFormBackingObjectValidator(this.calendarAccountDao));
    }

    @RequestMapping(method={RequestMethod.GET})
    protected String setupForm(@RequestParam(value="noscript", required=false, defaultValue="false") boolean noscript, ModelMap model) {
        model.addAttribute("command", (Object)new ModifyAdhocRelationshipFormBackingObject());
        if (noscript) {
            return "owner-relationships/create-adhoc-relationship-form-noscript";
        }
        return "owner-relationships/create-adhoc-relationship-form";
    }

    @RequestMapping(method={RequestMethod.POST})
    protected String createRelationship(@Valid @ModelAttribute(value="command") ModifyAdhocRelationshipFormBackingObject fbo, BindingResult bindResult, ModelMap model) throws CalendarAccountNotFoundException, NotAVisitorException, NotRegisteredException {
        if (bindResult.hasErrors()) {
            return "owner-relationships/create-adhoc-relationship-form";
        }
        CalendarAccountUserDetails currentUser = (CalendarAccountUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        IScheduleOwner owner = currentUser.getScheduleOwner();
        ICalendarAccount visitorUser = this.calendarAccountDao.getCalendarAccount(this.identifyingAttributeName, fbo.getVisitorUsername());
        if (null == visitorUser) {
            throw new CalendarAccountNotFoundException(fbo.getVisitorUsername() + " does not exist or is not eligible for WiscCal");
        }
        IScheduleVisitor visitor = this.visitorDao.toVisitor(visitorUser);
        this.mutableRelationshipDao.createRelationship(owner, visitor, fbo.getRelationship());
        model.addAttribute("visitor", (Object)visitor);
        model.addAttribute("relationship", (Object)fbo.getRelationship());
        return "owner-relationships/create-adhoc-relationship-success";
    }
}

