/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.register;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.jasig.schedassist.model.MeetingDurations;
import org.jasig.schedassist.model.Preferences;
import org.jasig.schedassist.model.VisibleWindow;
import org.jasig.schedassist.web.owner.preferences.PreferencesFormBackingObject;
import org.jasig.schedassist.web.owner.preferences.PreferencesFormBackingObjectValidator;
import org.jasig.schedassist.web.owner.schedule.BlockBuilderFormBackingObject;
import org.jasig.schedassist.web.owner.schedule.BlockBuilderFormBackingObjectValidator;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.binding.validation.ValidationContext;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;

public class Registration
implements Serializable {
    private static final long serialVersionUID = 53706L;
    private static final String COMMA = ",";
    private String location = Preferences.LOCATION.getDefaultValue();
    private String titlePrefix = Preferences.MEETING_PREFIX.getDefaultValue();
    private String meetingLength = Integer.toString(MeetingDurations.THIRTY.getMinLength());
    private boolean allowDoubleLength = false;
    private int windowHoursStart = VisibleWindow.DEFAULT.getWindowHoursStart();
    private int windowWeeksEnd = VisibleWindow.DEFAULT.getWindowWeeksEnd();
    private String noteboard = null;
    private int defaultVisitorsPerAppointment = 1;
    private boolean enableMeetingLimit = false;
    private int meetingLimitValue = -1;
    private boolean reflectSchedule = false;
    private boolean enableEmailReminders = false;
    private boolean emailReminderIncludeOwner = false;
    private int emailReminderHours = 24;
    private String startTimePhrase;
    private String endTimePhrase;
    private String daysOfWeekPhrase;
    private String startDatePhrase;
    private String endDatePhrase;
    private boolean scheduleSet = false;
    private final PreferencesFormBackingObjectValidator preferencesValidator;

    public Registration(PreferencesFormBackingObjectValidator preferencesValidator) {
        this.preferencesValidator = preferencesValidator;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getTitlePrefix() {
        return this.titlePrefix;
    }

    public void setTitlePrefix(String titlePrefix) {
        this.titlePrefix = titlePrefix;
    }

    public String getMeetingLength() {
        return this.meetingLength;
    }

    public void setMeetingLength(String meetingLength) {
        this.meetingLength = meetingLength;
    }

    public boolean isAllowDoubleLength() {
        return this.allowDoubleLength;
    }

    public void setAllowDoubleLength(boolean allowDoubleLength) {
        this.allowDoubleLength = allowDoubleLength;
    }

    public int getWindowHoursStart() {
        return this.windowHoursStart;
    }

    public void setWindowHoursStart(int windowHoursStart) {
        this.windowHoursStart = windowHoursStart;
    }

    public int getWindowWeeksEnd() {
        return this.windowWeeksEnd;
    }

    public void setWindowWeeksEnd(int windowWeeksEnd) {
        this.windowWeeksEnd = windowWeeksEnd;
    }

    public String getNoteboard() {
        return this.noteboard;
    }

    public String[] getNoteboardSentences() {
        if (StringUtils.isBlank((String)this.noteboard)) {
            return new String[0];
        }
        String[] noteboardSentences = this.noteboard.split("\n");
        return noteboardSentences;
    }

    public void setNoteboard(String noteboard) {
        this.noteboard = noteboard;
    }

    public boolean isReflectSchedule() {
        return this.reflectSchedule;
    }

    public void setReflectSchedule(boolean reflectSchedule) {
        this.reflectSchedule = reflectSchedule;
    }

    public String getStartTimePhrase() {
        return this.startTimePhrase;
    }

    public void setStartTimePhrase(String startTimePhrase) {
        this.startTimePhrase = startTimePhrase;
    }

    public String getEndTimePhrase() {
        return this.endTimePhrase;
    }

    public void setEndTimePhrase(String endTimePhrase) {
        this.endTimePhrase = endTimePhrase;
    }

    public String getDaysOfWeekPhrase() {
        return this.daysOfWeekPhrase;
    }

    public void setDaysOfWeekPhrase(String daysOfWeekPhrase) {
        this.daysOfWeekPhrase = daysOfWeekPhrase;
    }

    public String getStartDatePhrase() {
        return this.startDatePhrase;
    }

    public void setStartDatePhrase(String startDatePhrase) {
        this.startDatePhrase = startDatePhrase;
    }

    public String getEndDatePhrase() {
        return this.endDatePhrase;
    }

    public void setEndDatePhrase(String endDatePhrase) {
        this.endDatePhrase = endDatePhrase;
    }

    public int getDefaultVisitorsPerAppointment() {
        return this.defaultVisitorsPerAppointment;
    }

    public void setDefaultVisitorsPerAppointment(int defaultVisitorsPerAppointment) {
        this.defaultVisitorsPerAppointment = defaultVisitorsPerAppointment;
    }

    public boolean isEnableMeetingLimit() {
        return this.enableMeetingLimit;
    }

    public void setEnableMeetingLimit(boolean enableMeetingLimit) {
        this.enableMeetingLimit = enableMeetingLimit;
    }

    public int getMeetingLimitValue() {
        return this.meetingLimitValue;
    }

    public boolean isEnableEmailReminders() {
        return this.enableEmailReminders;
    }

    public void setEnableEmailReminders(boolean enableEmailReminders) {
        this.enableEmailReminders = enableEmailReminders;
    }

    public boolean isEmailReminderIncludeOwner() {
        return this.emailReminderIncludeOwner;
    }

    public void setEmailReminderIncludeOwner(boolean emailReminderIncludeOwner) {
        this.emailReminderIncludeOwner = emailReminderIncludeOwner;
    }

    public int getEmailReminderHours() {
        return this.emailReminderHours;
    }

    public void setEmailReminderHours(int emailReminderHours) {
        this.emailReminderHours = emailReminderHours;
    }

    public String emailReminderPreferenceKey() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.enableEmailReminders);
        builder.append(COMMA);
        builder.append(this.emailReminderIncludeOwner);
        builder.append(COMMA);
        builder.append(this.emailReminderHours);
        return builder.toString();
    }

    public void setMeetingLimitValue(int meetingLimitValue) {
        this.meetingLimitValue = meetingLimitValue;
        if (meetingLimitValue == -1) {
            this.setEnableMeetingLimit(false);
        } else {
            this.setEnableMeetingLimit(true);
        }
    }

    public boolean isScheduleSet() {
        return this.scheduleSet;
    }

    public String durationPreferenceValue() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.meetingLength);
        if (this.allowDoubleLength) {
            int duration = Integer.parseInt(this.meetingLength);
            builder.append(COMMA);
            builder.append(2 * duration);
        }
        return builder.toString();
    }

    public String visibleWindowPreferenceKey() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.windowHoursStart);
        builder.append(COMMA);
        builder.append(this.windowWeeksEnd);
        return builder.toString();
    }

    protected BlockBuilderFormBackingObject toBlockBuilderFormBackingObject() {
        BlockBuilderFormBackingObject command = new BlockBuilderFormBackingObject();
        command.setDaysOfWeekPhrase(this.daysOfWeekPhrase);
        command.setEndDatePhrase(this.endDatePhrase);
        command.setEndTimePhrase(this.endTimePhrase);
        command.setStartDatePhrase(this.startDatePhrase);
        command.setStartTimePhrase(this.startTimePhrase);
        command.setVisitorsPerAppointment(this.defaultVisitorsPerAppointment);
        return command;
    }

    protected PreferencesFormBackingObject toPreferencesFormBackingObject() {
        PreferencesFormBackingObject command = new PreferencesFormBackingObject();
        command.setAllowDoubleLength(this.allowDoubleLength);
        command.setDefaultVisitorsPerAppointment(this.defaultVisitorsPerAppointment);
        command.setEnableMeetingLimit(this.enableMeetingLimit);
        command.setLocation(this.location);
        command.setMeetingLength(this.meetingLength);
        command.setMeetingLimitValue(this.meetingLimitValue);
        command.setNoteboard(this.noteboard);
        command.setReflectSchedule(this.reflectSchedule);
        command.setTitlePrefix(this.titlePrefix);
        command.setWindowHoursStart(this.windowHoursStart);
        command.setWindowWeeksEnd(this.windowWeeksEnd);
        return command;
    }

    public void validateSetPreferences(ValidationContext context) {
        MessageContext messages = context.getMessageContext();
        PreferencesFormBackingObject command = this.toPreferencesFormBackingObject();
        BeanPropertyBindingResult errors = new BeanPropertyBindingResult((Object)command, "registration");
        this.preferencesValidator.validate((Object)command, (Errors)errors);
        if (errors.hasErrors()) {
            for (FieldError error : errors.getFieldErrors()) {
                messages.addMessage(new MessageBuilder().error().source((Object)error.getField()).defaultText(error.getDefaultMessage()).build());
            }
        }
    }

    public void validateSetSchedule(ValidationContext context) {
        MessageContext messages = context.getMessageContext();
        BlockBuilderFormBackingObject command = this.toBlockBuilderFormBackingObject();
        BlockBuilderFormBackingObjectValidator validator = new BlockBuilderFormBackingObjectValidator();
        BeanPropertyBindingResult errors = new BeanPropertyBindingResult((Object)command, "registration");
        validator.validate((Object)command, (Errors)errors);
        if (errors.hasErrors()) {
            for (FieldError error : errors.getFieldErrors()) {
                messages.addMessage(new MessageBuilder().error().source((Object)error.getField()).defaultText(error.getDefaultMessage()).build());
            }
        } else {
            this.scheduleSet = true;
        }
    }
}

