/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.security;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.IDelegateCalendarAccountDao;
import org.jasig.schedassist.impl.owner.OwnerDao;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.IDelegateCalendarAccount;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.web.security.CalendarAccountUserDetailsImpl;
import org.jasig.schedassist.web.security.DelegateCalendarAccountUserDetailsImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class DelegateCalendarAccountUserDetailsServiceImpl
implements UserDetailsService {
    private static final String NONE_PROVIDED = "NONE_PROVIDED";
    private IDelegateCalendarAccountDao delegateCalendarAccountDao;
    private OwnerDao ownerDao;
    protected final Log LOG = LogFactory.getLog(this.getClass());

    @Autowired
    public void setDelegateCalendarAccountDao(IDelegateCalendarAccountDao delegateCalendarAccountDao) {
        this.delegateCalendarAccountDao = delegateCalendarAccountDao;
    }

    @Autowired
    public void setOwnerDao(OwnerDao ownerDao) {
        this.ownerDao = ownerDao;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        if (NONE_PROVIDED.equals(username)) {
            this.LOG.debug((Object)"caught NONE_PROVIDED being passed into loadUserByUsername");
            throw new UsernameNotFoundException(NONE_PROVIDED);
        }
        CalendarAccountUserDetailsImpl currentUser = (CalendarAccountUserDetailsImpl)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        IDelegateCalendarAccount delegate = this.delegateCalendarAccountDao.getDelegate(username, currentUser.getCalendarAccount());
        if (null == delegate) {
            throw new UsernameNotFoundException("no delegate account found with name " + username);
        }
        IScheduleOwner delegateOwner = this.ownerDao.locateOwner((ICalendarAccount)delegate);
        DelegateCalendarAccountUserDetailsImpl result = new DelegateCalendarAccountUserDetailsImpl(delegate, delegateOwner);
        return result;
    }
}

