/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.admin;

import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jasig.schedassist.impl.statistics.StatisticsDao;
import org.jasig.schedassist.model.CommonDateOperations;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/admin/event-details.html"})
public class EventDetailsController {
    private StatisticsDao statisticsDao;

    @Autowired
    public void setStatisticsDao(StatisticsDao statisticsDao) {
        this.statisticsDao = statisticsDao;
    }

    public StatisticsDao getStatisticsDao() {
        return this.statisticsDao;
    }

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        SimpleDateFormat dateFormat = CommonDateOperations.getDateFormat();
        dateFormat.setLenient(false);
        binder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)dateFormat, false));
    }

    @RequestMapping(method={RequestMethod.GET})
    protected String getEventsForDate(@RequestParam(value="date", required=false) Date date, ModelMap model) {
        if (null != date) {
            model.addAttribute("date", (Object)date);
            List events = this.statisticsDao.getEvents(CommonDateOperations.beginningOfDay((Date)date), CommonDateOperations.endOfDay((Date)date));
            Collections.sort(events);
            model.addAttribute("events", (Object)events);
        }
        return "admin/event-details-day";
    }
}

