/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.owner.preferences;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.jasig.schedassist.model.Reminders;
import org.jasig.schedassist.web.owner.preferences.PreferencesFormBackingObject;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

@Component
public class PreferencesFormBackingObjectValidator
implements Validator,
InitializingBean,
Serializable {
    private static final long serialVersionUID = 6050605774023977200L;
    public static final int COLUMN_HARD_LIMIT = 512;
    public static final int MEETING_LENGTH_HARD_LIMIT = 720;
    private int noteboardMaxLength = 500;
    private int locationMaxLength = 100;
    private int titlePrefixMaxLength = 100;
    private int maxMeetingLength = 240;
    private int minMeetingLength = 15;

    @Value(value="${preferences.noteboardMaxLength:500}")
    public void setNoteboardMaxLength(int noteboardMaxLength) {
        this.noteboardMaxLength = noteboardMaxLength;
    }

    @Value(value="${preferences.locationMaxLength:100}")
    public void setLocationMaxLength(int locationMaxLength) {
        this.locationMaxLength = locationMaxLength;
    }

    @Value(value="${preferences.titlePrefixMaxLength:100}")
    public void setTitlePrefixMaxLength(int titlePrefixMaxLength) {
        this.titlePrefixMaxLength = titlePrefixMaxLength;
    }

    @Value(value="${preferences.maxMeetingLength:240}")
    public void setMaxMeetingLength(int maxMeetingLength) {
        this.maxMeetingLength = maxMeetingLength;
    }

    @Value(value="${preferences.minMeetingLength:15}")
    public void setMinMeetingLength(int minMeetingLength) {
        this.minMeetingLength = minMeetingLength;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.noteboardMaxLength >= 512) {
            throw new IllegalStateException("'preferences.noteboardMaxLength' property value (" + this.noteboardMaxLength + ") exceeds hard limit of " + 512 + "; this limit is tied to the database column size and cannot be exceeded without DDL changes");
        }
        if (this.titlePrefixMaxLength >= 512) {
            throw new IllegalStateException("'preferences.titlePrefixMaxLength' property value (" + this.titlePrefixMaxLength + ") exceeds hard limit of " + 512 + "; this limit is tied to the database column size and cannot be exceeded without DDL changes");
        }
        if (this.locationMaxLength >= 512) {
            throw new IllegalStateException("'preferences.locationMaxLength' property value (" + this.locationMaxLength + ") exceeds hard limit of " + 512 + "; this limit is tied to the database column size and cannot be exceeded without DDL changes");
        }
        if (this.maxMeetingLength >= 720) {
            throw new IllegalStateException("'preferences.maxMeetingLength' property value (" + this.maxMeetingLength + ") cannot be greater than 12 hours as double length appointments would span more than 1 day");
        }
        if (this.minMeetingLength < 10) {
            throw new IllegalStateException("'preferences.minMeetingLength' property value (" + this.minMeetingLength + ") should not be less than 10 minutes");
        }
    }

    public boolean supports(Class<?> clazz) {
        return PreferencesFormBackingObject.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        PreferencesFormBackingObject fbo = (PreferencesFormBackingObject)target;
        if (StringUtils.isBlank((String)fbo.getLocation())) {
            errors.rejectValue("location", "location.required", "Location field must not be empty.");
        } else if (fbo.getLocation().length() > this.locationMaxLength) {
            errors.rejectValue("location", "location.toolong", "Location field is too long (" + fbo.getLocation().length() + "); maximum length is " + this.locationMaxLength + " characters.");
        }
        if (StringUtils.isBlank((String)fbo.getTitlePrefix())) {
            errors.rejectValue("titlePrefix", "titlePrefix.required", "Meeting Title Prefix field must not be empty.");
        } else if (fbo.getTitlePrefix().length() > this.titlePrefixMaxLength) {
            errors.rejectValue("titlePrefix", "titlePrefix.toolong", "Meeting Title Prefix field is too long (" + fbo.getTitlePrefix().length() + "); maximum length is " + this.titlePrefixMaxLength + " characters.");
        }
        if (StringUtils.isBlank((String)fbo.getMeetingLength())) {
            errors.rejectValue("meetingLength", "meetingLength.required", "Meeting Length field must not be empty.");
        } else {
            try {
                int meetingLength = Integer.parseInt(fbo.getMeetingLength());
                if (meetingLength < this.minMeetingLength || meetingLength > this.maxMeetingLength) {
                    errors.rejectValue("meetingLength", "meetingLength.outofbounds", "Meeting Length must be greater than " + this.minMeetingLength + " minutes and less than " + this.maxMeetingLength + " minutes.");
                }
            }
            catch (NumberFormatException e) {
                errors.rejectValue("meetingLength", "meetingLength.invalid", "Invalid value for meeting duration.");
            }
        }
        if (fbo.getDefaultVisitorsPerAppointment() < 1) {
            errors.rejectValue("defaultVisitorsPerAppointment", "defaultVisitors.toosmall", "Default visitors per appointment must be greater than or equal to 1.");
        }
        if (fbo.getDefaultVisitorsPerAppointment() > 99) {
            errors.rejectValue("defaultVisitorsPerAppointment", "defaultVisitors.toosmall", "Maximum allowed value for default visitors per appointment is 99.");
        }
        if (fbo.getWindowHoursStart() < 1) {
            errors.rejectValue("windowHoursStart", "windowhoursstart.toosmall", "Your visible window start must be at least 1 hour.");
        }
        if (fbo.getWindowHoursStart() >= 168) {
            errors.rejectValue("windowHoursStart", "windowhoursstart.toolarge", "Your visible window start must be less than 168 hours (1 week).");
        }
        if (fbo.getWindowWeeksEnd() < 1) {
            errors.rejectValue("windowWeeksEnd", "windowweeksend.toosmall", "Your visible window end must be at least 1 week.");
        }
        if (fbo.getWindowWeeksEnd() > 26) {
            errors.rejectValue("windowWeeksEnd", "windowweeksend.toosmall", "Your visible window end cannot be greater than 26 weeks.");
        }
        if (fbo.isEnableMeetingLimit()) {
            if (fbo.getMeetingLimitValue() < 1) {
                errors.rejectValue("meetingLimitValue", "meetinglimitvalue.toosmall", "Meeting Limit value must be greater than or equal to 1.");
            } else if (fbo.getMeetingLimitValue() > 10) {
                errors.rejectValue("meetingLimitValue", "meetinglimitvalue.toolarge", "Meeting Limit value greater than 10 is not much of a limit; you should just disable meeting limits.");
            }
        } else {
            fbo.setMeetingLimitValue(-1);
        }
        if (StringUtils.isBlank((String)fbo.getNoteboard())) {
            errors.rejectValue("noteboard", "noteboard.required", "Noteboard field is required.");
        } else {
            String noteboardNoControlM = fbo.getNoteboard().replaceAll("\\r", "");
            fbo.setNoteboard(noteboardNoControlM);
            if (null != fbo.getNoteboard() && fbo.getNoteboard().length() > this.noteboardMaxLength) {
                errors.rejectValue("noteboard", "noteboard.toolarge", "Noteboard is too long (" + fbo.getNoteboard().length() + " characters); maximum length is " + this.noteboardMaxLength + " characters.");
            }
        }
        if (fbo.isEnableEmailReminders()) {
            if (fbo.getEmailReminderHours() < 1 || fbo.getEmailReminderHours() > 99) {
                errors.rejectValue("emailReminderHours", "emailReminderHours.outofbounds", "Email reminder hours must be between 1 and 99.");
            }
        } else {
            fbo.setEmailReminderHours(Reminders.DEFAULT.getHours());
            fbo.setEmailReminderIncludeOwner(Reminders.DEFAULT.isIncludeOwner());
        }
    }
}

