/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.owner.relationships;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jasig.schedassist.ICalendarAccountDao;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.web.owner.relationships.ModifyAdhocRelationshipFormBackingObject;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class ModifyAdhocRelationshipFormBackingObjectValidator
implements Validator {
    private static final String VALID_USERNAME_REGEX = "[\\w\\d\\.\\-\\_@]+";
    private static final Pattern VALID_USERNAME_PATTERN = Pattern.compile("[\\w\\d\\.\\-\\_@]+");
    private ICalendarAccountDao calendarAccountDao;

    public ModifyAdhocRelationshipFormBackingObjectValidator(ICalendarAccountDao calendarAccountDao) {
        this.calendarAccountDao = calendarAccountDao;
    }

    public boolean supports(Class<?> clazz) {
        return ModifyAdhocRelationshipFormBackingObject.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        ModifyAdhocRelationshipFormBackingObject fbo = (ModifyAdhocRelationshipFormBackingObject)target;
        Matcher m = VALID_USERNAME_PATTERN.matcher(fbo.getVisitorUsername());
        if (StringUtils.isBlank((String)fbo.getVisitorUsername())) {
            errors.rejectValue("visitorUsername", "visitor.notfound", "Account not found or not eligible for Calendar Service.");
        } else if (!m.matches()) {
            errors.rejectValue("visitorUsername", "visitor.notfound", "Account not found or not eligible for Calendar Service.");
        } else {
            ICalendarAccount account = this.calendarAccountDao.getCalendarAccount(fbo.getVisitorUsername());
            if (null == account) {
                errors.rejectValue("visitorUsername", "visitor.notfound", "Account not found or not eligible for Calendar Service.");
            }
        }
        if (StringUtils.isBlank((String)fbo.getRelationship())) {
            errors.rejectValue("relationship", "relationship.empty", "You must specify a description for your relationship.");
        } else if (fbo.getRelationship().length() > 64) {
            errors.rejectValue("relationship", "relationship.toolong", "Relationship description is too long, please shorten to less than 64 characters.");
        }
    }
}

