/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.profiles;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jasig.schedassist.impl.owner.PublicProfileDao;
import org.jasig.schedassist.model.PublicProfileId;
import org.jasig.schedassist.web.profiles.ProfilePageInformation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class TaggedPublicProfileController {
    private PublicProfileDao publicProfileDao;

    @Autowired
    public void setPublicProfileDao(PublicProfileDao publicProfileDao) {
        this.publicProfileDao = publicProfileDao;
    }

    public PublicProfileDao getPublicProfileDao() {
        return this.publicProfileDao;
    }

    @RequestMapping(value={"/public/tags/{tag}"}, method={RequestMethod.GET})
    public String displayProfileIdsByTag(ModelMap model, @PathVariable(value="tag") String tag, @RequestParam(value="startIndex", required=false, defaultValue="0") int startIndex) throws UnsupportedEncodingException {
        String decoded = this.decode(tag);
        List profileIds = this.publicProfileDao.getPublicProfileIdsWithTag(decoded);
        if (profileIds.isEmpty()) {
            return "profiles/public-listing";
        }
        Collections.sort(profileIds);
        ProfilePageInformation pageInfo = new ProfilePageInformation(profileIds, startIndex);
        List<PublicProfileId> sublist = pageInfo.getSublist();
        Map profileMap = this.publicProfileDao.getProfileTagsBatch(sublist);
        model.addAttribute("titleSuffix", (Object)this.buildPageTitleSuffix(tag, pageInfo.getStartIndex(), pageInfo.getEndIndex()));
        model.addAttribute("profileIds", sublist);
        model.addAttribute("profileMap", (Object)profileMap);
        model.addAttribute("showPrev", (Object)pageInfo.isShowPrev());
        model.addAttribute("showPrevIndex", (Object)pageInfo.getShowPrevIndex());
        model.addAttribute("showNext", (Object)pageInfo.isShowNext());
        model.addAttribute("showNextIndex", (Object)pageInfo.getShowNextIndex());
        return "profiles/public-listing";
    }

    protected String buildPageTitleSuffix(String tag, int startIndex, int endIndex) {
        StringBuilder title = new StringBuilder();
        title.append(" labeled with '");
        title.append(tag);
        title.append("' - ");
        title.append(startIndex == 0 ? 1 : startIndex + 1);
        title.append(" - ");
        title.append(endIndex);
        return title.toString();
    }

    private String decode(String tag) {
        try {
            String decoded = URLDecoder.decode(tag, "UTF-8");
            return decoded;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("caught unexpected UnsupportedEncodingException for UTF-8", e);
        }
    }
}

