/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.admin;

import java.util.Date;
import java.util.List;
import org.jasig.schedassist.impl.statistics.DailyEventSummary;
import org.jasig.schedassist.impl.statistics.StatisticsDao;
import org.jasig.schedassist.model.CommonDateOperations;
import org.jasig.schedassist.web.admin.DateRangeFormBackingObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.SessionAttributes;

@Controller
@RequestMapping(value={"/admin/events-summary.html"})
@SessionAttributes(value={"command"})
public class EventsSummaryFormController {
    private StatisticsDao statisticsDao;

    @Autowired
    public void setStatisticsDao(StatisticsDao statisticsDao) {
        this.statisticsDao = statisticsDao;
    }

    public StatisticsDao getStatisticsDao() {
        return this.statisticsDao;
    }

    @RequestMapping(method={RequestMethod.GET})
    protected String setupForm(ModelMap model) {
        DateRangeFormBackingObject fbo = new DateRangeFormBackingObject();
        model.put((Object)"command", (Object)fbo);
        return "admin/events-summary-form";
    }

    @RequestMapping(method={RequestMethod.POST})
    protected String getEventCounts(@ModelAttribute(value="command") DateRangeFormBackingObject fbo, ModelMap model) {
        List eventCounts = this.statisticsDao.getEventCounts(CommonDateOperations.beginningOfDay((Date)fbo.getStart()), CommonDateOperations.endOfDay((Date)fbo.getEnd()));
        int rangeTotal = 0;
        for (DailyEventSummary s : eventCounts) {
            rangeTotal = (int)((long)rangeTotal + s.getEventCount());
        }
        model.addAttribute("rangeTotal", (Object)rangeTotal);
        model.addAttribute("eventCounts", (Object)eventCounts);
        return "admin/events-summary-results";
    }
}

