/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.admin;

import javax.validation.Valid;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.IScheduleVisitor;
import org.jasig.schedassist.web.admin.VisibleScheduleDebugFormBackingObject;
import org.jasig.schedassist.web.admin.VisibleScheduleDebugFormBackingObjectValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;

@Controller
@RequestMapping(value={"/admin/schedule-debug.html"})
@SessionAttributes(value={"command"})
public class VisibleScheduleDebugFormController {
    private VisibleScheduleDebugFormBackingObjectValidator validator;

    @Autowired
    public void setValidator(VisibleScheduleDebugFormBackingObjectValidator validator) {
        this.validator = validator;
    }

    @InitBinder
    protected void initBinder(WebDataBinder binder) {
        binder.setValidator((Validator)this.validator);
    }

    @RequestMapping(method={RequestMethod.GET})
    protected String setupForm(ModelMap model) {
        VisibleScheduleDebugFormBackingObject command = new VisibleScheduleDebugFormBackingObject();
        model.addAttribute("command", (Object)command);
        return "admin/debug-lookup-form";
    }

    @RequestMapping(method={RequestMethod.POST})
    public String displaySchedule(@Valid @ModelAttribute(value="command") VisibleScheduleDebugFormBackingObject command, BindingResult bindingResult, @RequestParam(value="highContrast", required=false, defaultValue="false") boolean highContrast, @RequestParam(value="weekStart", required=false, defaultValue="0") int weekStart, ModelMap model) {
        if (bindingResult.hasErrors()) {
            return "admin/debug-lookup-form";
        }
        IScheduleOwner selectedOwner = command.getScheduleOwner();
        IScheduleVisitor visitor = command.getScheduleVisitor();
        StringBuilder redirectUrl = new StringBuilder();
        redirectUrl.append("redirect:/admin/schedule-debug/");
        redirectUrl.append(selectedOwner.getId());
        redirectUrl.append("/view.html?visitorUsername=");
        redirectUrl.append(visitor.getCalendarAccount().getUsername());
        return redirectUrl.toString();
    }
}

