/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.owner.preferences;

import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.jasig.schedassist.IAffiliationSource;
import org.jasig.schedassist.impl.owner.NotRegisteredException;
import org.jasig.schedassist.impl.owner.OwnerDao;
import org.jasig.schedassist.impl.owner.PublicProfileAlreadyExistsException;
import org.jasig.schedassist.impl.owner.PublicProfileDao;
import org.jasig.schedassist.model.AffiliationImpl;
import org.jasig.schedassist.model.IAffiliation;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.Preferences;
import org.jasig.schedassist.model.PublicProfile;
import org.jasig.schedassist.model.PublicProfileTag;
import org.jasig.schedassist.web.owner.preferences.AdvancedPreferencesFormBackingObject;
import org.jasig.schedassist.web.owner.preferences.AdvancedPreferencesFormBackingObjectValidator;
import org.jasig.schedassist.web.security.CalendarAccountUserDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.SessionAttributes;

@Controller
@RequestMapping(value={"/owner/advanced.html", "/delegate/advanced.html"})
@SessionAttributes(value={"command"})
public class AdvancedPreferencesFormController {
    private OwnerDao ownerDao;
    private PublicProfileDao publicProfileDao;
    private IAffiliationSource affiliationSource;

    @Autowired
    public void setOwnerDao(OwnerDao ownerDao) {
        this.ownerDao = ownerDao;
    }

    @Autowired
    public void setPublicProfileDao(PublicProfileDao publicProfileDao) {
        this.publicProfileDao = publicProfileDao;
    }

    @Autowired
    public void setAffiliationSource(IAffiliationSource affiliationSource) {
        this.affiliationSource = affiliationSource;
    }

    public OwnerDao getOwnerDao() {
        return this.ownerDao;
    }

    public PublicProfileDao getPublicProfileDao() {
        return this.publicProfileDao;
    }

    public IAffiliationSource getAffiliationSource() {
        return this.affiliationSource;
    }

    @InitBinder(value={"command"})
    protected void initBinder(WebDataBinder binder) {
        binder.setValidator((Validator)new AdvancedPreferencesFormBackingObjectValidator());
    }

    @RequestMapping(method={RequestMethod.GET})
    protected String setupForm(ModelMap model) throws NotRegisteredException {
        CalendarAccountUserDetails currentUser = (CalendarAccountUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        IScheduleOwner owner = currentUser.getScheduleOwner();
        AdvancedPreferencesFormBackingObject fbo = new AdvancedPreferencesFormBackingObject();
        PublicProfile existingProfile = this.publicProfileDao.locatePublicProfileByOwner(owner);
        fbo.setCreatePublicProfile(null != existingProfile);
        if (fbo.isCreatePublicProfile()) {
            fbo.setPublicProfileDescription(existingProfile.getDescription());
            fbo.setPublicProfileKey(existingProfile.getPublicProfileId().getProfileKey());
            List tags = this.publicProfileDao.getProfileTags(existingProfile.getPublicProfileId());
            fbo.setPublicProfileTags(this.tagsAsString(tags));
        }
        boolean isAdvisor = this.affiliationSource.doesAccountHaveAffiliation(owner.getCalendarAccount(), (IAffiliation)AffiliationImpl.ADVISOR);
        fbo.setEligibleForAdvisor(isAdvisor);
        if (isAdvisor) {
            String prefValue = owner.getPreference(Preferences.ADVISOR_SHARE_WITH_STUDENTS);
            fbo.setAdvisorShareWithStudents(Boolean.parseBoolean(prefValue));
        }
        boolean isInstructor = this.affiliationSource.doesAccountHaveAffiliation(owner.getCalendarAccount(), (IAffiliation)AffiliationImpl.INSTRUCTOR);
        fbo.setEligibleForInstructor(isInstructor);
        if (isInstructor) {
            String prefValue = owner.getPreference(Preferences.INSTRUCTOR_SHARE_WITH_STUDENTS);
            fbo.setInstructorShareWithStudents(Boolean.parseBoolean(prefValue));
        }
        model.addAttribute("command", (Object)fbo);
        return "owner-preferences/advanced-preferences-form";
    }

    @RequestMapping(method={RequestMethod.POST})
    protected String updateAdvancedPreferences(@Valid @ModelAttribute(value="command") AdvancedPreferencesFormBackingObject fbo, BindingResult bindingResult, ModelMap model) throws NotRegisteredException, PublicProfileAlreadyExistsException {
        CalendarAccountUserDetails currentUser = (CalendarAccountUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        IScheduleOwner owner = currentUser.getScheduleOwner();
        if (bindingResult.hasErrors()) {
            return "owner-preferences/advanced-preferences-form";
        }
        if (this.affiliationSource.doesAccountHaveAffiliation(owner.getCalendarAccount(), (IAffiliation)AffiliationImpl.ADVISOR) && !owner.getPreference(Preferences.ADVISOR_SHARE_WITH_STUDENTS).equals(String.valueOf(fbo.isAdvisorShareWithStudents()))) {
            owner = this.ownerDao.updatePreference(owner, Preferences.ADVISOR_SHARE_WITH_STUDENTS, String.valueOf(fbo.isAdvisorShareWithStudents()));
            if (fbo.isAdvisorShareWithStudents()) {
                model.addAttribute("advisorShareWithStudentsOn", (Object)true);
            } else {
                model.addAttribute("advisorShareWithStudentsOff", (Object)true);
            }
        }
        if (this.affiliationSource.doesAccountHaveAffiliation(owner.getCalendarAccount(), (IAffiliation)AffiliationImpl.INSTRUCTOR) && !owner.getPreference(Preferences.INSTRUCTOR_SHARE_WITH_STUDENTS).equals(String.valueOf(fbo.isInstructorShareWithStudents()))) {
            owner = this.ownerDao.updatePreference(owner, Preferences.INSTRUCTOR_SHARE_WITH_STUDENTS, String.valueOf(fbo.isInstructorShareWithStudents()));
            if (fbo.isInstructorShareWithStudents()) {
                model.addAttribute("instructorShareWithStudentsOn", (Object)true);
            } else {
                model.addAttribute("instructorShareWithStudentsOff", (Object)true);
            }
        }
        PublicProfile existingProfile = this.publicProfileDao.locatePublicProfileByOwner(owner);
        if (fbo.isCreatePublicProfile() && null == existingProfile) {
            PublicProfile newProfile = this.publicProfileDao.createPublicProfile(owner, fbo.getPublicProfileDescription());
            model.addAttribute("createdPublicProfile", (Object)true);
            model.addAttribute("publicProfileKey", (Object)newProfile.getPublicProfileId().getProfileKey());
            if (StringUtils.isNotBlank((String)fbo.getPublicProfileTags())) {
                List newTags = this.commaSeparatedToList(fbo.getPublicProfileTags());
                this.publicProfileDao.setProfileTags(newTags, newProfile.getPublicProfileId());
                model.addAttribute("updatedPublicProfileTags", (Object)true);
            }
        } else if (!fbo.isCreatePublicProfile() && null != existingProfile) {
            this.publicProfileDao.removePublicProfile(existingProfile.getPublicProfileId());
            model.put((Object)"removedPublicProfile", (Object)true);
        } else if (fbo.isCreatePublicProfile() && null != existingProfile) {
            List tags;
            if (!existingProfile.getDescription().equals(fbo.getPublicProfileDescription())) {
                this.publicProfileDao.updatePublicProfileDescription(existingProfile.getPublicProfileId(), fbo.getPublicProfileDescription());
                model.addAttribute("updatedPublicProfile", (Object)true);
            }
            if (!this.tagsAsString(tags = this.publicProfileDao.getProfileTags(existingProfile.getPublicProfileId())).equals(fbo.getPublicProfileTags())) {
                List newTags = this.commaSeparatedToList(fbo.getPublicProfileTags());
                this.publicProfileDao.setProfileTags(newTags, existingProfile.getPublicProfileId());
                model.addAttribute("updatedPublicProfileTags", (Object)true);
            }
        }
        currentUser.updateScheduleOwner(owner);
        return "owner-preferences/advanced-preferences-success";
    }

    protected String tagsAsString(List<PublicProfileTag> tags) {
        StringBuilder tagsAsString = new StringBuilder();
        for (int i = 0; i < tags.size(); ++i) {
            PublicProfileTag tag = tags.get(i);
            tagsAsString.append(tag.getTagDisplay());
            if (i >= tags.size() - 1) continue;
            tagsAsString.append(",");
        }
        return tagsAsString.toString();
    }

    protected List<String> commaSeparatedToList(String tags) {
        String[] tokens;
        ArrayList<String> result = new ArrayList<String>();
        if (StringUtils.isBlank((String)tags)) {
            return result;
        }
        for (String token : tokens = tags.split(",\\s*")) {
            result.add(token);
        }
        return result;
    }
}

