/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.owner.relationships;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jasig.schedassist.RelationshipDao;
import org.jasig.schedassist.impl.owner.NotRegisteredException;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.Relationship;
import org.jasig.schedassist.web.owner.relationships.AdhocRelationshipsDataController;
import org.jasig.schedassist.web.security.CalendarAccountUserDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/owner/authorized-visitors.json", "/delegate/authorized-visitors.json"})
public class AdhocRelationshipsDataController {
    private RelationshipDao relationshipDao;
    private String identifyingAttributeName = "uid";

    @Autowired
    public void setRelationshipDao(@Qualifier(value="adhoc") RelationshipDao relationshipDao) {
        this.relationshipDao = relationshipDao;
    }

    public RelationshipDao getRelationshipDao() {
        return this.relationshipDao;
    }

    @Value(value="${users.visibleIdentifierAttributeName:uid}")
    public void setIdentifyingAttributeName(String identifyingAttributeName) {
        this.identifyingAttributeName = identifyingAttributeName;
    }

    public String getIdentifyingAttributeName() {
        return this.identifyingAttributeName;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String getRelationshipsData(ModelMap model) throws NotRegisteredException {
        CalendarAccountUserDetails currentUser = (CalendarAccountUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        IScheduleOwner owner = currentUser.getScheduleOwner();
        List relationships = this.relationshipDao.forOwner(owner);
        ArrayList<AdhocRelationshipVisitorDataBean> beans = new ArrayList<AdhocRelationshipVisitorDataBean>();
        if (relationships.size() > 0) {
            for (Relationship r : relationships) {
                beans.add(this.convert(r));
            }
            Collections.sort(beans, new /* Unavailable Anonymous Inner Class!! */);
        }
        model.put((Object)"relationships", beans);
        return "jsonView";
    }

    protected AdhocRelationshipVisitorDataBean convert(Relationship relationship) {
        AdhocRelationshipVisitorDataBean result = new AdhocRelationshipVisitorDataBean();
        result.setDescription(relationship.getDescription());
        result.setFullName(relationship.getVisitor().getCalendarAccount().getDisplayName());
        result.setUsername(relationship.getVisitor().getCalendarAccount().getAttributeValue(this.identifyingAttributeName));
        return result;
    }
}

