/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.owner.schedule;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.validation.Valid;
import org.jasig.schedassist.impl.owner.AvailableScheduleDao;
import org.jasig.schedassist.impl.owner.NotRegisteredException;
import org.jasig.schedassist.model.AvailableBlock;
import org.jasig.schedassist.model.AvailableBlockBuilder;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.InputFormatException;
import org.jasig.schedassist.web.owner.schedule.AvailableBlockFormBackingObject;
import org.jasig.schedassist.web.owner.schedule.AvailableBlockFormBackingObjectValidator;
import org.jasig.schedassist.web.security.CalendarAccountUserDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/owner/remove-block.html", "/delegate/remove-block.html"})
public class RemoveAvailableBlockFormController {
    private AvailableScheduleDao availableScheduleDao;

    @Autowired
    public void setAvailableScheduleDao(AvailableScheduleDao availableScheduleDao) {
        this.availableScheduleDao = availableScheduleDao;
    }

    public AvailableScheduleDao getAvailableScheduleDao() {
        return this.availableScheduleDao;
    }

    @InitBinder(value={"command"})
    protected void initBinder(WebDataBinder binder) {
        binder.setValidator((Validator)new AvailableBlockFormBackingObjectValidator());
    }

    @RequestMapping(method={RequestMethod.GET})
    protected String setupForm(ModelMap model, @RequestParam(value="interactive", required=false, defaultValue="false") boolean interactive) throws NotRegisteredException {
        AvailableBlockFormBackingObject fbo = new AvailableBlockFormBackingObject();
        fbo.setInteractive(interactive);
        model.addAttribute("command", (Object)fbo);
        return "owner-schedule/remove-form";
    }

    @RequestMapping(method={RequestMethod.POST})
    protected String removeAvailableBlock(@Valid @ModelAttribute(value="command") AvailableBlockFormBackingObject fbo, BindingResult bindingResult, ModelMap model) throws NotRegisteredException, InputFormatException {
        CalendarAccountUserDetails currentUser = (CalendarAccountUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        IScheduleOwner owner = currentUser.getScheduleOwner();
        if (bindingResult.hasErrors()) {
            if (fbo.isInteractive()) {
                return "owner-schedule/remove-form";
            }
            model.addAttribute("reason", (Object)"An unexpected error occurred; refresh the page and try again.");
            return "jsonView";
        }
        AvailableBlock block = AvailableBlockBuilder.createSmallestAllowedBlock((String)fbo.getStartTimePhrase());
        if (null != fbo.getEndTimePhrase() && !"".equals(fbo.getEndTimePhrase())) {
            block = AvailableBlockBuilder.createBlock((String)fbo.getStartTimePhrase(), (String)fbo.getEndTimePhrase());
        }
        this.availableScheduleDao.removeFromSchedule(owner, block);
        model.addAttribute("blockStart", (Object)this.formatDate(block.getStartTime()));
        model.addAttribute("blockEnd", (Object)this.formatDate(block.getEndTime()));
        model.addAttribute("blockId", (Object)this.formatBlockId(block.getStartTime()));
        model.addAttribute("visitorLimit", (Object)block.getVisitorLimit());
        if (fbo.isInteractive()) {
            return "owner-schedule/remove-block-success";
        }
        return "jsonView";
    }

    private String formatBlockId(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("EEEHHmm");
        return df.format(date);
    }

    private String formatDate(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("MMM d, yyyy HH:mm");
        return df.format(date);
    }
}

