/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jasig.schedassist.impl.owner.NotRegisteredException;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.IScheduleVisitor;
import org.jasig.schedassist.web.security.CalendarAccountUserDetails;
import org.jasig.schedassist.web.security.SecurityConstants;
import org.springframework.security.core.GrantedAuthority;

public class CalendarAccountUserDetailsImpl
implements CalendarAccountUserDetails {
    private static final long serialVersionUID = 53706L;
    private final ICalendarAccount calendarAccount;
    private IScheduleVisitor scheduleVisitor;
    private IScheduleOwner scheduleOwner;
    private boolean administrator = false;
    private String activeDisplayNameAttribute = "mail";
    private static final String EMPTY = "";

    CalendarAccountUserDetailsImpl(ICalendarAccount calendarAccount) {
        this.calendarAccount = calendarAccount;
    }

    CalendarAccountUserDetailsImpl(ICalendarAccount calendarAccount, IScheduleOwner scheduleOwner) {
        this.calendarAccount = calendarAccount;
        this.scheduleOwner = scheduleOwner;
    }

    CalendarAccountUserDetailsImpl(ICalendarAccount calendarAccount, IScheduleOwner scheduleOwner, String activeDisplayNameAttribute) {
        this.calendarAccount = calendarAccount;
        this.scheduleOwner = scheduleOwner;
        this.activeDisplayNameAttribute = activeDisplayNameAttribute;
    }

    public String getActiveDisplayNameAttribute() {
        return this.activeDisplayNameAttribute;
    }

    public void setActiveDisplayNameAttribute(String activeDisplayNameAttribute) {
        this.activeDisplayNameAttribute = activeDisplayNameAttribute;
    }

    public Collection<GrantedAuthority> getAuthorities() {
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        if (null != this.calendarAccount && this.calendarAccount.isEligible()) {
            authorities.add(SecurityConstants.REGISTER);
            authorities.add(SecurityConstants.DELEGATE_LOGIN);
        }
        if (null != this.scheduleVisitor && this.scheduleVisitor.getCalendarAccount().isEligible()) {
            authorities.add(SecurityConstants.VISITOR);
        }
        if (null != this.scheduleOwner && this.scheduleOwner.getCalendarAccount().isEligible()) {
            authorities.add(SecurityConstants.OWNER);
            authorities.remove(SecurityConstants.REGISTER);
        }
        if (this.administrator) {
            authorities.add(SecurityConstants.AVAILABLE_ADMINISTRATOR);
        }
        return Collections.unmodifiableList(authorities);
    }

    public String getPassword() {
        return EMPTY;
    }

    public String getUsername() {
        return this.calendarAccount.getUsername();
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return null != this.calendarAccount ? this.calendarAccount.isEligible() : false;
    }

    public ICalendarAccount getCalendarAccount() {
        return this.calendarAccount;
    }

    public IScheduleVisitor getScheduleVisitor() {
        return this.scheduleVisitor;
    }

    public IScheduleOwner getScheduleOwner() throws NotRegisteredException {
        if (null == this.scheduleOwner) {
            throw new NotRegisteredException(this.calendarAccount + " is not registered");
        }
        return this.scheduleOwner;
    }

    public final boolean isDelegate() {
        return false;
    }

    void setScheduleVisitor(IScheduleVisitor scheduleVisitor) {
        this.scheduleVisitor = scheduleVisitor;
    }

    void setScheduleOwner(IScheduleOwner scheduleOwner) {
        this.scheduleOwner = scheduleOwner;
    }

    boolean isAdministrator() {
        return this.administrator;
    }

    void setAdministrator(boolean administrator) {
        this.administrator = administrator;
    }

    public void updateScheduleOwner(IScheduleOwner scheduleOwner) {
        this.scheduleOwner = scheduleOwner;
    }

    public boolean isScheduleOwnerSet() {
        return null != this.scheduleOwner;
    }

    public boolean isScheduleVisitorSet() {
        return null != this.scheduleVisitor;
    }

    public String getActiveDisplayName() {
        StringBuilder display = new StringBuilder();
        display.append(this.calendarAccount.getDisplayName());
        display.append(" (");
        display.append(this.calendarAccount.getAttributeValue(this.activeDisplayNameAttribute));
        display.append(")");
        return display.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CalendarAccountUserDetailsImpl [calendarAccount=");
        builder.append(this.calendarAccount);
        builder.append(", scheduleVisitor=");
        builder.append(this.scheduleVisitor);
        builder.append(", scheduleOwner=");
        builder.append(this.scheduleOwner);
        builder.append(", administrator=");
        builder.append(this.administrator);
        builder.append("]");
        return builder.toString();
    }
}

