/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.visitor;

import java.util.List;
import org.jasig.schedassist.RelationshipDao;
import org.jasig.schedassist.impl.visitor.NotAVisitorException;
import org.jasig.schedassist.model.IScheduleVisitor;
import org.jasig.schedassist.web.security.CalendarAccountUserDetailsImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class OwnerSelectionController {
    private RelationshipDao relationshipDao;

    @Autowired
    public void setRelationshipDao(@Qualifier(value="composite") RelationshipDao relationshipDao) {
        this.relationshipDao = relationshipDao;
    }

    public RelationshipDao getRelationshipDao() {
        return this.relationshipDao;
    }

    @RequestMapping(value={"/visitor.html"}, method={RequestMethod.GET})
    protected String getRelationships(ModelMap model) throws NotAVisitorException {
        CalendarAccountUserDetailsImpl currentUser = (CalendarAccountUserDetailsImpl)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        IScheduleVisitor visitor = currentUser.getScheduleVisitor();
        List relationships = this.relationshipDao.forVisitor(visitor);
        model.addAttribute("relationships", (Object)relationships);
        return "visitor/owner-select";
    }
}

