/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.visitor;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jasig.schedassist.RelationshipDao;
import org.jasig.schedassist.SchedulingAssistantService;
import org.jasig.schedassist.impl.owner.OwnerDao;
import org.jasig.schedassist.impl.owner.PublicProfileDao;
import org.jasig.schedassist.impl.visitor.NotAVisitorException;
import org.jasig.schedassist.model.AvailableBlock;
import org.jasig.schedassist.model.CommonDateOperations;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.IScheduleVisitor;
import org.jasig.schedassist.model.PublicProfile;
import org.jasig.schedassist.model.Relationship;
import org.jasig.schedassist.model.VisibleScheduleRequestConstraints;
import org.jasig.schedassist.web.security.CalendarAccountUserDetailsImpl;
import org.jasig.schedassist.web.visitor.OwnerNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJacksonJsonView;

@Controller
public class VisitorScheduleController {
    private OwnerDao ownerDao;
    private RelationshipDao relationshipDao;
    private PublicProfileDao publicProfileDao;
    private SchedulingAssistantService schedulingAssistantService;

    @Autowired
    public void setOwnerDao(OwnerDao ownerDao) {
        this.ownerDao = ownerDao;
    }

    @Autowired
    public void setRelationshipDao(@Qualifier(value="composite") RelationshipDao relationshipDao) {
        this.relationshipDao = relationshipDao;
    }

    @Autowired
    public void setPublicProfileDao(PublicProfileDao publicProfileDao) {
        this.publicProfileDao = publicProfileDao;
    }

    @Autowired
    public void setSchedulingAssistantService(SchedulingAssistantService schedulingAssistantService) {
        this.schedulingAssistantService = schedulingAssistantService;
    }

    public OwnerDao getOwnerDao() {
        return this.ownerDao;
    }

    public RelationshipDao getRelationshipDao() {
        return this.relationshipDao;
    }

    public PublicProfileDao getPublicProfileDao() {
        return this.publicProfileDao;
    }

    public SchedulingAssistantService getSchedulingAssistantService() {
        return this.schedulingAssistantService;
    }

    @RequestMapping(value={"/schedule/{ownerIdentifier}/visitor-conflicts.json"}, method={RequestMethod.GET})
    public View retrieveVisitorConflicts(@PathVariable(value="ownerIdentifier") String ownerIdentifier, @RequestParam(value="weekStart", required=false, defaultValue="0") int weekStart, ModelMap model) throws NotAVisitorException, OwnerNotFoundException {
        CalendarAccountUserDetailsImpl currentUser = (CalendarAccountUserDetailsImpl)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        IScheduleVisitor visitor = currentUser.getScheduleVisitor();
        IScheduleOwner owner = this.locateOwnerFromIdentifier(ownerIdentifier, visitor);
        VisibleScheduleRequestConstraints requestConstraints = VisibleScheduleRequestConstraints.newInstance((IScheduleOwner)owner, (int)weekStart);
        List visitorConflicts = this.schedulingAssistantService.calculateVisitorConflicts(visitor, owner, requestConstraints.getTargetStartDate(), requestConstraints.getTargetEndDate());
        ArrayList<String> conflictBlocks = new ArrayList<String>();
        SimpleDateFormat df = CommonDateOperations.getDateTimeFormat();
        for (AvailableBlock b : visitorConflicts) {
            conflictBlocks.add(df.format(b.getStartTime()));
        }
        model.addAttribute("conflicts", conflictBlocks);
        return new MappingJacksonJsonView();
    }

    private IScheduleOwner locateOwnerFromIdentifier(String ownerIdentifier, IScheduleVisitor visitor) throws OwnerNotFoundException {
        IScheduleOwner selectedOwner = null;
        if (StringUtils.isNumeric((String)ownerIdentifier)) {
            Long ownerId = Long.parseLong(ownerIdentifier);
            selectedOwner = this.findOwnerForVisitor(visitor, ownerId.longValue());
        } else {
            PublicProfile profile = this.publicProfileDao.locatePublicProfileByKey(ownerIdentifier);
            if (null != profile) {
                selectedOwner = this.ownerDao.locateOwnerByAvailableId(profile.getOwnerId());
            }
        }
        if (null == selectedOwner) {
            throw new OwnerNotFoundException("no owner found for " + ownerIdentifier);
        }
        return selectedOwner;
    }

    private IScheduleOwner findOwnerForVisitor(IScheduleVisitor visitor, long ownerId) throws OwnerNotFoundException {
        List relationships = this.relationshipDao.forVisitor(visitor);
        for (Relationship potential : relationships) {
            if (potential.getOwner().getId() != ownerId) continue;
            return potential.getOwner();
        }
        throw new OwnerNotFoundException("owner id " + ownerId + " not found");
    }
}

