/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.owner.relationships;

import java.util.List;
import org.jasig.schedassist.MutableRelationshipDao;
import org.jasig.schedassist.impl.owner.NotRegisteredException;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.web.security.CalendarAccountUserDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/owner/sharing.html", "/delegate/sharing.html"})
public class AdhocRelationshipsController {
    private MutableRelationshipDao mutableRelationshipDao;

    @Autowired
    public void setMutableRelationshipDao(MutableRelationshipDao mutableRelationshipDao) {
        this.mutableRelationshipDao = mutableRelationshipDao;
    }

    public MutableRelationshipDao getMutableRelationshipDao() {
        return this.mutableRelationshipDao;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String getAdhocRelationships(ModelMap model) throws NotRegisteredException {
        CalendarAccountUserDetails currentUser = (CalendarAccountUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        IScheduleOwner owner = currentUser.getScheduleOwner();
        List relationships = this.mutableRelationshipDao.forOwner(owner);
        model.addAttribute("relationships", (Object)relationships);
        return "owner-relationships/adhoc-authorizations";
    }
}

