/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.owner.schedule;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.impl.owner.AvailableScheduleDao;
import org.jasig.schedassist.impl.owner.NotRegisteredException;
import org.jasig.schedassist.model.AvailableBlock;
import org.jasig.schedassist.model.AvailableBlockBuilder;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.InputFormatException;
import org.jasig.schedassist.web.security.CalendarAccountUserDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@RequestMapping(value={"/owner/remove-block-alternate.html", "/delegate/remove-block-alternate.html"})
public class AlternateRemoveAvailableBlockController {
    protected final Log log = LogFactory.getLog(this.getClass());
    private AvailableScheduleDao availableScheduleDao;

    @Autowired
    public void setAvailableScheduleDao(AvailableScheduleDao availableScheduleDao) {
        this.availableScheduleDao = availableScheduleDao;
    }

    public AvailableScheduleDao getAvailableScheduleDao() {
        return this.availableScheduleDao;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView removeBlock(@RequestParam(value="startTime", required=true) String startTimePhrase, @RequestParam(value="endTime", required=true) String endTimePhrase) throws NotRegisteredException {
        CalendarAccountUserDetails currentUser = (CalendarAccountUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        IScheduleOwner owner = currentUser.getScheduleOwner();
        try {
            AvailableBlock block = AvailableBlockBuilder.createBlock((String)startTimePhrase, (String)endTimePhrase);
            this.log.debug((Object)("parsed request parameters: " + block));
            this.availableScheduleDao.removeFromSchedule(owner, block);
        }
        catch (InputFormatException e) {
            this.log.info((Object)"cannot create block", (Throwable)e);
        }
        return new ModelAndView((View)new RedirectView("schedule-noscript.html", true));
    }
}

