/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.security.delegate;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jasig.schedassist.IDelegateCalendarAccountDao;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.IDelegateCalendarAccount;
import org.jasig.schedassist.web.security.CalendarAccountUserDetailsImpl;
import org.jasig.schedassist.web.security.delegate.DelegateAccountSearchFormBackingObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;

@Controller
@RequestMapping(value={"/delegate-search.html"})
@SessionAttributes(value={"command"})
public class DelegateAccountSearchFormController {
    private IDelegateCalendarAccountDao delegateCalendarAccountDao;

    @Autowired
    public void setDelegateCalendarAccountDao(IDelegateCalendarAccountDao delegateCalendarAccountDao) {
        this.delegateCalendarAccountDao = delegateCalendarAccountDao;
    }

    public IDelegateCalendarAccountDao getDelegateCalendarAccountDao() {
        return this.delegateCalendarAccountDao;
    }

    @RequestMapping(method={RequestMethod.GET})
    protected String onGet(@RequestParam(value="q", required=false) String qValue, ModelMap model) {
        if (StringUtils.isBlank((String)qValue)) {
            DelegateAccountSearchFormBackingObject fbo = new DelegateAccountSearchFormBackingObject();
            model.addAttribute("command", (Object)fbo);
            return "security/delegate-search-form";
        }
        CalendarAccountUserDetailsImpl currentUser = (CalendarAccountUserDetailsImpl)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        ICalendarAccount currentAccount = currentUser.getCalendarAccount();
        model.addAttribute("searchText", (Object)qValue);
        List<Object> matches = new ArrayList<IDelegateCalendarAccount>();
        if (null != qValue && qValue.length() > 2) {
            String searchText = StringUtils.replace((String)qValue, (String)" ", (String)"*");
            matches = this.delegateCalendarAccountDao.searchForDelegates(searchText, currentAccount);
        }
        List<IDelegateCalendarAccount> results = this.filterForEligible(matches);
        model.addAttribute("results", results);
        return "security/delegate-search-results-ac";
    }

    @RequestMapping(method={RequestMethod.POST})
    protected String search(@ModelAttribute(value="command") DelegateAccountSearchFormBackingObject fbo, ModelMap model) {
        CalendarAccountUserDetailsImpl currentUser = (CalendarAccountUserDetailsImpl)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        ICalendarAccount currentAccount = currentUser.getCalendarAccount();
        model.addAttribute("searchText", (Object)fbo.getSearchText());
        List<Object> matches = new ArrayList<IDelegateCalendarAccount>();
        if (null != fbo.getSearchText() && fbo.getSearchText().length() > 2) {
            String searchText = StringUtils.replace((String)fbo.getSearchText(), (String)" ", (String)"*");
            matches = this.delegateCalendarAccountDao.searchForDelegates(searchText, currentAccount);
        }
        List<IDelegateCalendarAccount> results = this.filterForEligible(matches);
        model.addAttribute("results", results);
        return "security/delegate-search-results";
    }

    protected List<IDelegateCalendarAccount> filterForEligible(List<IDelegateCalendarAccount> matches) {
        ArrayList<IDelegateCalendarAccount> results = new ArrayList<IDelegateCalendarAccount>();
        for (IDelegateCalendarAccount a : matches) {
            if (!a.isEligible()) continue;
            results.add(a);
        }
        return results;
    }
}

