/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.admin;

import org.jasig.schedassist.ICalendarAccountDao;
import org.jasig.schedassist.impl.AvailableScheduleReflectionService;
import org.jasig.schedassist.impl.owner.AvailableScheduleDao;
import org.jasig.schedassist.impl.owner.OwnerDao;
import org.jasig.schedassist.model.AvailableSchedule;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.web.admin.ScheduleOwnerFormBackingObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/admin/reflection-service.html"})
public class AvailableScheduleReflectionServiceController {
    private ICalendarAccountDao calendarAccountDao;
    private OwnerDao ownerDao;
    private AvailableScheduleReflectionService reflectionService;
    private AvailableScheduleDao availableScheduleDao;

    @Autowired
    public void setCalendarAccountDao(ICalendarAccountDao calendarAccountDao) {
        this.calendarAccountDao = calendarAccountDao;
    }

    @Autowired
    public void setOwnerDao(OwnerDao ownerDao) {
        this.ownerDao = ownerDao;
    }

    @Autowired
    public void setReflectionService(AvailableScheduleReflectionService reflectionService) {
        this.reflectionService = reflectionService;
    }

    @Autowired
    public void setAvailableScheduleDao(AvailableScheduleDao availableScheduleDao) {
        this.availableScheduleDao = availableScheduleDao;
    }

    public ICalendarAccountDao getCalendarAccountDao() {
        return this.calendarAccountDao;
    }

    public OwnerDao getOwnerDao() {
        return this.ownerDao;
    }

    public AvailableScheduleReflectionService getReflectionService() {
        return this.reflectionService;
    }

    public AvailableScheduleDao getAvailableScheduleDao() {
        return this.availableScheduleDao;
    }

    @RequestMapping
    protected String setupForm(ModelMap model) {
        ScheduleOwnerFormBackingObject command = new ScheduleOwnerFormBackingObject();
        model.addAttribute("command", (Object)command);
        return "admin/reflect-form";
    }

    @RequestMapping(method={RequestMethod.POST}, params={"action=reflect"})
    protected String reflectAvailableSchedule(@ModelAttribute(value="command") ScheduleOwnerFormBackingObject command) {
        IScheduleOwner owner = null;
        if (command.getOwnerId() != null) {
            owner = this.ownerDao.locateOwnerByAvailableId(command.getOwnerId().longValue());
        } else {
            ICalendarAccount account = this.calendarAccountDao.getCalendarAccount(command.getUsername());
            if (account != null) {
                owner = this.ownerDao.locateOwner(account);
            }
        }
        if (owner == null) {
            return "owner-not-found";
        }
        this.reflectionService.reflectAvailableSchedule(owner);
        return "admin/reflect-success";
    }

    @RequestMapping(method={RequestMethod.POST}, params={"action=purge"})
    protected String purgeReflections(ScheduleOwnerFormBackingObject command) {
        IScheduleOwner owner = null;
        if (command.getOwnerId() != null) {
            owner = this.ownerDao.locateOwnerByAvailableId(command.getOwnerId().longValue());
        } else {
            ICalendarAccount account = this.calendarAccountDao.getCalendarAccount(command.getUsername());
            if (account != null) {
                owner = this.ownerDao.locateOwner(account);
            }
        }
        if (owner == null) {
            return "admin/owner-not-found";
        }
        AvailableSchedule schedule = this.availableScheduleDao.retrieve(owner);
        if (!schedule.isEmpty()) {
            this.reflectionService.purgeReflections(owner, schedule.getScheduleStartTime(), schedule.getScheduleEndTime());
        }
        return "admin/reflect-purge-success";
    }
}

